% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propensity.R
\name{propensity}
\alias{propensity}
\title{Estimating propensity scores}
\usage{
propensity(formula, data, link = "logit", late.Z, late.X, env = parent.frame())
}
\arguments{
\item{formula}{Formula characterizing probability model. If a
variable in the data already contains the propensity scores,
input the variable as a one-sided formula. For example, if the
variable \code{pz} contains the propensity score, input
\code{formula = ~ pz}.}

\item{data}{\code{data.frame} with which to estimate the model.}

\item{link}{Link function with which to estimate probability
model. Can be chosen from "linear", "logit", or "probit".}

\item{late.Z}{A vector of variable names of excluded
variables. This is required when the target parameter is the
LATE.}

\item{late.X}{A vector of variable names of non-excluded
variables. This is required when the target parameter is the
LATE, and the estimation procedure will condition on these
variables.}

\item{env}{environment, the environment for the original
propensity score formula.}
}
\value{
A vector of propensity scores for each observation, as well
    as a 'model'. If the user inputs a formula characterizing the
    model for taking up treatment, then the \code{lm}/\code{glm}
    object is returned. If the user declares a variable in the data
    set to be used as the propensity score, then a
    \code{data.frame} containing the propensity score for each
    value of the covariates in the probability model is returned.
}
\description{
This function estimates the propensity of taking up treatment. The
user can choose from fitting a linear probability model, a logit
model, or a probit model. The function can also be used to generate
a table of propensity scores for a given set of covariates and
excluded variables. This was incorporated to account for the LATE
being a target parameter. Specifically, if the argument
\code{formula} is the name of a variable in \code{data}, but the
target parameter is not the LATE, then no propensity model is
returned. If the target parameter is the LATE, then then the
propensity model is simply the empirical distribution of propensity
scores in the data conditioned on the set of covariates declared in
\code{late.X} and \code{late.Z}.
}
\examples{
dtm <- ivmte:::gendistMosquito()

## Declaring a probability model.
propensity(formula = d ~ z,
               data = dtm,
               link = "linear")

## Declaring a variable to be used instead
propensity(formula = ~ pz,
               data = dtm,
               link = "linear")

}
