% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp.R
\name{lpSetupEqualCoef}
\alias{lpSetupEqualCoef}
\title{Generate equality constraints}
\usage{
lpSetupEqualCoef(equal.coef0, equal.coef1, ANames)
}
\arguments{
\item{equal.coef0}{character, name of terms in \code{m0} that
should have common coefficients with the corresponding terms in
\code{m1}.}

\item{equal.coef1}{character, name of terms in \code{m1} that
should have common coefficients with the corresponding terms in
\code{m0}.}

\item{ANames}{character, name of all terms in \code{m0} and
\code{m1}. The names of the terms corresponding to the
treatment and control groups should be distinguishable. For
example, all terms for \code{m0} may contain a prefix '[m0]',
and all terms for \code{m1} may contain a prefix '[m1]'. All
the terms in \code{equal.coef0} and \code{equal.coef1} should
be contained in \code{ANames}.}
}
\value{
A list, containing the matrix of linear equality
    constraints, a vector of equal signs, and a vector of 0s.
}
\description{
This function generates the linear constraints to ensure that
certain MTR coefficients are constant across the treatment and
control group.
}
