% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACER.R
\name{ACER}
\alias{ACER}
\title{Two-sided test for the average cluster effect ratio estimand}
\usage{
ACER(
  num_t,
  num_c,
  R_t,
  R_c,
  d_t,
  d_c,
  lambda,
  alpha = 0.05,
  kappa = 0.1,
  gap = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{num_t}{A length-K vector where K is equal to the number of
clusters and the kth entry equal to the number of
units in the encouraged cluster of the kth matched
pair of two clusters.}

\item{num_c}{A length-K vector with the kth entry equal to the number of
units in the control cluster of the kth matched
pair of two clusters.}

\item{R_t}{A length-K vector with kth entry equal to
the sum of unit-level outcomes in the encouraged cluster
of the kth matched pair of two clusters.}

\item{R_c}{A length-K vector with the kth entry equal to
the sum of unit-level outcomes in the control cluster
of the kth matched pair of two clusters.}

\item{d_t}{A length-K vector with the kth entry equal to the sum
of unit-level treatment received in the encouraged cluster
of the kth matched pair of two clusters.}

\item{d_c}{A length-K vector with the kth entry equal to the sum
of unit-level treatment received in the control cluster
of the kth matched pair of two clusters.}

\item{lambda}{The magnitude of the average cluster effect ratio (ACER)
to be tested.}

\item{alpha}{The level of the test.}

\item{kappa}{Minimum compliance rate.}

\item{gap}{Relative MIP optimality gap.}

\item{verbose}{If true, the solver output is enabled; otherwise,
the solver output is disabled.}
}
\value{
A list of three elements: the optimal solution, the optimal
        objective value, and an indicator of whether or not the test
        is rejected.
}
\description{
\code{ACER} tests (two-sided) if the average cluster effect
ratio (ACER) is equal to lambda.
}
\examples{
\dontrun{
# To run the following example, Gurobi must be installed.

R_t = encouraged_clusters$aggregated_outcome
R_c = control_clusters$aggregated_outcome
d_t = encouraged_clusters$aggregated_treatment
d_c = control_clusters$aggregated_treatment
num_t = encouraged_clusters$number_units
num_c = control_clusters$number_units

# Test at level 0.05 if the ACER is equal
# to 0.2. Assume the minimum compliance rate across
# K clusters is at least 0.2. Set verbose = FALSE
# to suppress the output.
res = ACER(num_t, num_c, R_t, R_c, d_t, d_c,
          lambda = 0.2, alpha = 0.05, kappa = 0.2,
          verbose = FALSE)

# The test is rejected
res$Reject
}
}
