% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rng.R
\name{makeIwrapper}
\alias{makeIwrapper}
\title{Iterator Constructor-Constructor Function Wrapper}
\usage{
makeIwrapper(FUN)
}
\arguments{
\item{FUN}{a function that generates different values each time it
is called; typically one of the standard random number generator
functions.}
}
\value{
An iterator that is a wrapper around the corresponding
function.
}
\description{
The \code{makeIwrapper} function wraps an R function to produce an
iterator constructor.  It is used to construct random sampling
iterators in this package; for instance \code{irnorm} is defined as
\code{irnorm <- makeIwrapper(rnorm)}.
}
\details{
The resulting iterator constructors all take an optional
\code{count} argument which specifies the number of times the
resulting iterator should fire. They also have an argument
\code{independent} which enables independent tracking of the random
number seed. The \code{isample} function is an example of one such
iterator constructoe (as are \code{irnorm}, \code{irunif}, etc.).

Original version appeared in the \code{iterators} package.
}
\examples{

# create an iterator maker for the sample function
mysample <- makeIwrapper(sample)
# use this iterator maker to generate an iterator that will generate three five
# member samples from the sequence 1:100
it <- mysample(1:100, 5, count = 3)
nextOr(it)
nextOr(it)
nextOr(it)
nextOr(it, NULL)  # NULL
}
