% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iroundrobin.R
\name{i_roundrobin}
\alias{i_roundrobin}
\title{Iteror that traverses each given iterable in a roundrobin order}
\usage{
i_roundrobin(...)
}
\arguments{
\item{...}{multiple arguments to iterate through in roundrobin sequence}
}
\value{
iterator that alternates through each argument in roundrobin sequence
}
\description{
Constructs an iterator that traverses each given iterable in a roundrobin
order. That is, the iterables are traversed in an alternating fashion such
that the each element is drawn from the next iterable. If an iterable has no
more available elements, it is skipped, and the next element is taken from
the next iterable having available elements.
}
\examples{
it <- iteror(c("A", "B", "C"))
it2 <- iteror("D")
it3 <- iteror(c("E", "F"))
as.list(i_roundrobin(it, it2, it3)) # A D E B F C

it_rr <- i_roundrobin(1:3, 4:5, 7:10)
as.list(it_rr) # 1 4 7 2 5 8 3 9 10

}
