% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{graph.lattice}
\alias{graph.lattice}
\title{Create a lattice graph}
\usage{
graph.lattice(
  dimvector = NULL,
  length = NULL,
  dim = NULL,
  nei = 1,
  directed = FALSE,
  mutual = FALSE,
  periodic = FALSE,
  circular = deprecated()
)
}
\arguments{
\item{dimvector}{A vector giving the size of the lattice in each
dimension.}

\item{length}{Integer constant, for regular lattices, the size of the
lattice in each dimension.}

\item{dim}{Integer constant, the dimension of the lattice.}

\item{nei}{The distance within which (inclusive) the neighbors on the
lattice will be connected. This parameter is not used right now.}

\item{directed}{Whether to create a directed lattice.}

\item{mutual}{Logical, if \code{TRUE} directed lattices will be
mutually connected.}

\item{periodic}{Logical vector, Boolean vector, defines whether the generated lattice is
periodic along each dimension. This parameter may also be scalar boolen value which will
be extended to boolean vector with dimvector length.}

\item{circular}{Deprecated, use \code{periodic} instead.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{graph.lattice()} was renamed to \code{\link[=make_lattice]{make_lattice()}} to create a more
consistent API.
}
\keyword{internal}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Generators.html#igraph_square_lattice}{\code{square_lattice()}}.}

