% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTDmodel-methods.R
\name{MTD-methods}
\alias{MTD-methods}
\title{Methods for objects of class \code{"MTD"}}
\arguments{
\item{x}{An object of class \code{"MTD"} (for \code{print.MTD(x, ...)}).}

\item{object}{An object of class \code{"MTD"}.}

\item{X}{A vector or single-column data frame containing an MTD chain sample
(required for \code{logLik.MTD(object, X, ...)}). Values must be in the model's state space.}

\item{...}{Further arguments passed to or from other methods (ignored).}
}
\value{
\describe{
\item{\code{print.MTD}}{Invisibly returns the \code{"MTD"} object, after
displaying its relevant lag set and state space.}
\item{\code{summary.MTD}}{Invisibly returns a named list with fields:
\code{call}, \code{order}, \code{Lambda}, \code{states},
\code{lags}, \code{indep}, \code{lambdas}, \code{pj},
\code{p0} (or \code{NULL}), \code{P_dim}, and \code{P}. The same
information is printed to the console in a readable format.}
\item{\code{coef.MTD}}{A list with parameters:
\code{lambdas}, \code{pj}, and \code{p0}.}
\item{\code{logLik.MTD}}{An object of class \code{"logLik"} with attributes
\code{nobs} (number of transitions) and \code{df} (free parameters),
honoring model constraints such as \code{single_matrix} and the independent
component (\code{indep_part}).}
}
}
\description{
Printing, summarizing, and coefficient-extraction methods for Mixture
Transition Distribution (MTD) model objects.
}
\details{
\itemize{
\item \code{print.MTD()} displays a compact summary of the model:
the relevant lag set (shown as negative integers) and the state space.

\item \code{summary.MTD()} computes and prints a detailed summary of the
model, including order, relevant lags, state space, mixture weights,
the independent distribution (if present), and a compact preview of
the global transition matrix \eqn{P}.

\item \code{coef.MTD()} extracts parameters as a list with \code{lambdas},
\code{pj}, and \code{p0} (works for \code{c("MTDest","MTD")} objects by inheritance).

\item \code{logLik.MTD()} computes the log-likelihood of a sample under the
model. Since an object of class \code{"MTD"} carries only the model
parameters, a sample \code{X} must be supplied. The method honors
constraints such as \code{single_matrix} and an independent component
(\code{indep_part}), and returns an object of class \code{"logLik"}
with appropriate attributes.
}
}
\examples{
\dontrun{
set.seed(1)
m <- MTDmodel(Lambda = c(1, 3), A = c(0, 1), lam0 = 0.05)

print(m)       # compact display: lags (Z^-) and state space
s <- summary(m)
str(s)

coef(m)        # list(lambdas = ..., pj = ..., p0 = ...)
transitP(m)    # global transition matrix P
pj(m); p0(m); lambdas(m); lags(m); Lambda(m); states(m)

X <- perfectSample(m, N = 400)
logLik(m, X)
}

}
\seealso{
\code{\link{MTDmodel}}, \code{\link{MTDest}} for fitted models (note that "MTDest"
objects inherit from "MTD"),
\code{\link{transitP}}, \code{\link{lambdas}}, \code{\link{pj}},
\code{\link{p0}}, \code{\link{lags}}, \code{\link{Lambda}}, \code{\link{states}},
\code{\link{oscillation}}, \code{\link{perfectSample}}, \code{\link{probs}},
\code{\link[stats]{logLik}}
}
