% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qq_plot.R
\name{qq_plot}
\alias{qq_plot}
\title{QQ Plot}
\usage{
qq_plot(
  data,
  point_col = "black",
  diag_col = "red",
  diag_line = "solid",
  title = NULL
)
}
\arguments{
\item{data}{PLINK assoc output, tab-delimited, or a data.frame with "P" column.}

\item{point_col}{A character vector indicating the color to use for the SNP p-values. Default is "black".}

\item{diag_col}{A character vector indicating the color to use for the diagonal line. Default is "red".}

\item{diag_line}{A character vector indicating the line type to use for the diagonal line. Default is "solid".}

\item{title}{A string denoting the title to use for the plot. Default is 'Q-Q Plot'}
}
\value{
A Q-Q plot.
}
\description{
Creates a Q-Q plot
}
\details{
Creates a Q-Q plot from PLINK assoc output (or any tab-delimited file or data frame with "P" column).
}
\examples{
qq_plot(gwasData)

}
\author{
Lindokuhle Nkambule
}
