% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-other-methods.R
\name{family.gkwreg}
\alias{family.gkwreg}
\title{Extract Family from GKw Regression Model}
\usage{
\method{family}{gkwreg}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"gkwreg"}.}

\item{...}{Currently not used.}
}
\value{
A character string indicating the family used in the model.
}
\description{
Extracts the family specification from a fitted Generalized Kumaraswamy
regression model object.
}
\examples{
\donttest{
data(GasolineYield)
fit <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")
family(fit)
}

}
\seealso{
\code{\link{gkwreg}}
}
\author{
Lopes, J. E.
}
