% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{gisco_countrycode}
\alias{gisco_countrycode}
\title{Database with different country code schemes and world regions}
\format{
A data frame object with
249 rows and 13
variables:
\describe{
\item{\code{ISO3_CODE}}{Eurostat code of each country.}
\item{\code{CNTR_CODE}}{ISO 3166-1 alpha-2 code of each country.}
\item{\code{iso2c}}{ISO 3166-1 alpha-3 code of each country.}
\item{\code{iso.name.en}}{ISO English short name.}
\item{\code{cldr.short.en}}{English short name as provided by the Unicode Common
Locale Data Repository.}
\item{\code{continent}}{As provided by the World Bank.}
\item{\code{un.region.code}}{Numeric region code UN (M49).}
\item{\code{un.region.name}}{Region name UN (M49).}
\item{\code{un.regionintermediate.code}}{Numeric intermediate Region.}
\item{\code{un.regionintermediate.name}}{Intermediate Region name UN (M49).}
\item{\code{un.regionsub.code}}{Numeric sub-region code UN (M49).}
\item{\code{un.regionsub.name}}{Sub-Region name UN (M49).}
\item{\code{eu}}{Logical indicating if the country belongs to the
European Union.}
}
}
\source{
\link[countrycode:codelist]{countrycode::codelist} \strong{v1.6.1}.
}
\description{
A \link[tibble:tbl_df-class]{tibble} containing conversions between different country
code schemes (Eurostat/ISO2 and 3) as well as geographic regions as
provided by the World Bank and the UN
(\href{https://unstats.un.org/unsd/methodology/m49/}{M49 Standard}). This database
has been extracted from the \CRANpkg{countrycode} package.
}
\section{World Regions}{
Regions are defined as per the geographic regions defined by the
UN (see \url{https://unstats.un.org/unsd/methodology/m49/}.
Under this scheme Cyprus is assigned to Asia.
}

\examples{
data("gisco_countrycode")
dplyr::glimpse(gisco_countrycode)
}
\seealso{
\code{\link[=gisco_get_countries]{gisco_get_countries()}}, \link[countrycode:codelist]{countrycode::codelist}.

See also the \href{https://cldr.unicode.org/translation/displaynames/countryregion-territory-names}{Unicode Common Locale Data Repository}.

Other datasets: 
\code{\link{gisco_coastal_lines}},
\code{\link{gisco_countries_2024}},
\code{\link{gisco_db}},
\code{\link{gisco_nuts_2024}}
}
\concept{datasets}
