% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-colour.R, R/zxx.R
\name{scale_colour_continuous}
\alias{scale_colour_continuous}
\alias{scale_fill_continuous}
\alias{scale_colour_binned}
\alias{scale_fill_binned}
\alias{scale_color_continuous}
\alias{scale_color_binned}
\title{Continuous and binned colour scales}
\usage{
scale_colour_continuous(
  ...,
  palette = NULL,
  aesthetics = "colour",
  guide = "colourbar",
  na.value = "grey50",
  type = getOption("ggplot2.continuous.colour")
)

scale_fill_continuous(
  ...,
  palette = NULL,
  aesthetics = "fill",
  guide = "colourbar",
  na.value = "grey50",
  type = getOption("ggplot2.continuous.fill")
)

scale_colour_binned(
  ...,
  palette = NULL,
  aesthetics = "colour",
  guide = "coloursteps",
  na.value = "grey50",
  type = getOption("ggplot2.binned.colour")
)

scale_fill_binned(
  ...,
  palette = NULL,
  aesthetics = "fill",
  guide = "coloursteps",
  na.value = "grey50",
  type = getOption("ggplot2.binned.fill")
)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[=continuous_scale]{continuous_scale}}, \code{\link[=binned_scale]{binned_scale}}
  \describe{
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:new_transform]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}}).
Note that for position scales, limits are provided after scale expansion.
Also accepts rlang \link[rlang:as_function]{lambda} function notation.
}}
    \item{\code{n.breaks}}{An integer guiding the number of major breaks. The algorithm
may choose a slightly different number to ensure nice break labels. Will
only have an effect if \code{breaks = waiver()}. Use \code{NULL} to use the default
number of breaks given by the transformation.}
    \item{\code{labels}}{One of the options below. Please note that when \code{labels} is a
vector, it is highly recommended to also set the \code{breaks} argument as a
vector to protect against unintended mismatches.
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[=coord_cartesian]{coord_cartesian()}}).
}}
    \item{\code{rescaler}}{A function used to scale the input values to the
range [0, 1]. This is always \code{\link[scales:rescale]{scales::rescale()}}, except for
diverging and n colour gradients (i.e., \code{\link[=scale_colour_gradient2]{scale_colour_gradient2()}},
\code{\link[=scale_colour_gradientn]{scale_colour_gradientn()}}). The \code{rescaler} is ignored by position
scales, which always use \code{\link[scales:rescale]{scales::rescale()}}. Also accepts rlang
\link[rlang:as_function]{lambda} function notation.}
    \item{\code{oob}}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds). Also accepts rlang \link[rlang:as_function]{lambda}
function notation.
\item The default (\code{\link[scales:oob]{scales::censor()}}) replaces out of
bounds values with \code{NA}.
\item \code{\link[scales:oob]{scales::squish()}} for squishing out of bounds values into range.
\item \code{\link[scales:oob]{scales::squish_infinite()}} for squishing infinite values into range.
}}
    \item{\code{transform}}{For continuous scales, the name of a transformation object
or the object itself. Built-in transformations include "asn", "atanh",
"boxcox", "date", "exp", "hms", "identity", "log", "log10", "log1p", "log2",
"logit", "modulus", "probability", "probit", "pseudo_log", "reciprocal",
"reverse", "sqrt" and "time".

A transformation object bundles together a transform, its inverse,
and methods for generating breaks and labels. Transformation objects
are defined in the scales package, and are called \verb{transform_<name>}. If
transformations require arguments, you can call them from the scales
package, e.g. \code{\link[scales:transform_boxcox]{scales::transform_boxcox(p = 2)}}.
You can create your own transformation with \code{\link[scales:new_transform]{scales::new_transform()}}.}
    \item{\code{position}}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
    \item{\code{nice.breaks}}{Logical. Should breaks be attempted placed at nice values
instead of exactly evenly spaced between the limits. If \code{TRUE} (default)
the scale will ask the transformation object to create breaks, and this
may result in a different number of breaks than requested. Ignored if
breaks are given explicitly.}
    \item{\code{right}}{Should the intervals be closed on the right (\code{TRUE}, default) or
should the intervals be closed on the left (\code{FALSE})? 'Closed on the right'
means that values at break positions are part of the lower bin (open on the
left), whereas they are part of the upper bin when intervals are closed on
the left (open on the right).}
    \item{\code{show.limits}}{should the limits of the scale appear as ticks}
  }}

\item{palette}{One of the following:
\itemize{
\item \code{NULL} for the default palette stored in the theme.
\item a character vector of colours.
\item a single string naming a palette.
\item a palette function that when called with a numeric vector with values
between 0 and 1 returns the corresponding output values.
}}

\item{aesthetics}{The names of the aesthetics that this scale works with.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more information.}

\item{na.value}{Missing values will be replaced with this value.}

\item{type}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} The preferred mechanism for
setting the default palette is by using the theme. For example:
\code{theme(palette.colour.discrete = "viridis")}.}
}
\description{
The scales \code{scale_colour_continuous()} and \code{scale_fill_continuous()} are
the default colour scales ggplot2 uses when continuous data values are
mapped onto the \code{colour} or \code{fill} aesthetics, respectively. The scales
\code{scale_colour_binned()} and \code{scale_fill_binned()} are equivalent scale
functions that assign discrete color bins to the continuous values
instead of using a continuous color spectrum.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}: The mechanism of setting defaults via
\code{\link[=options]{options()}} is superseded by theme settings. The preferred method to change
the default palette of scales is via the theme, for example:
\code{theme(palette.colour.continuous = scales::pal_viridis())}. The
\code{ggplot2.continuous.colour} and \code{ggplot2.continuous.fill} options could be
used to set default continuous scales and \code{ggplot2.binned.colour} and
\code{ggplot2.binned.fill} options to set default binned scales.

These scale functions are meant to provide simple defaults. If
you want to manually set the colors of a scale, consider using
\code{\link[=scale_colour_gradient]{scale_colour_gradient()}} or \code{\link[=scale_colour_steps]{scale_colour_steps()}}.
}
\section{Color Blindness}{

Many color palettes derived from RGB combinations (like the "rainbow" color
palette) are not suitable to support all viewers, especially those with
color vision deficiencies. Using \code{viridis} type, which is perceptually
uniform in both colour and black-and-white display is an easy option to
ensure good perceptive properties of your visualizations.
The colorspace package offers functionalities
\itemize{
\item to generate color palettes with good perceptive properties,
\item to analyse a given color palette, like emulating color blindness,
\item and to modify a given color palette for better perceptivity.
}

For more information on color vision deficiencies and suitable color choices
see the \href{https://arxiv.org/abs/1903.06490}{paper on the colorspace package}
and references therein.
}

\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy, colour = cty)) +
  geom_point()

# You can use the scale to give a palette directly
p + scale_colour_continuous(palette = c("#FEE0D2", "#FC9272", "#DE2D26"))

# The default colours are encoded into the theme
p + theme(palette.colour.continuous = c("#DEEBF7", "#9ECAE1", "#3182BD"))

# You can globally set default colour palette via the theme
old <- update_theme(palette.colour.continuous = c("#E5F5E0", "#A1D99B", "#31A354"))

# Plot now shows new global default
p

# The default binned colour scale uses the continuous palette
p + scale_colour_binned() +
  theme(palette.colour.continuous = c("#EFEDF5", "#BCBDDC", "#756BB1"))

# Restoring the previous theme
theme_set(old)
}
\seealso{
\code{\link[=continuous_scale]{continuous_scale()}} and \code{\link[=binned_scale]{binned_scale()}}

The documentation on \link[=aes_colour_fill_alpha]{colour aesthetics}.

The \href{https://ggplot2-book.org/scales-colour#sec-colour-continuous}{continuous colour scales section} of the online ggplot2 book.

Other colour scales: 
\code{\link{scale_alpha}()},
\code{\link{scale_colour_brewer}()},
\code{\link{scale_colour_discrete}()},
\code{\link{scale_colour_gradient}()},
\code{\link{scale_colour_grey}()},
\code{\link{scale_colour_hue}()},
\code{\link{scale_colour_identity}()},
\code{\link{scale_colour_manual}()},
\code{\link{scale_colour_steps}()},
\code{\link{scale_colour_viridis_d}()}
}
\concept{colour scales}
