% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_counterfactual.R
\name{plot_counterfactual}
\alias{plot_counterfactual}
\title{Plot the Counterfactual Path}
\usage{
plot_counterfactual(
  x,
  plus_t = 5,
  facet.scales = "free",
  title = NULL,
  zero_line = FALSE,
  regex_exclude_indicators = NULL
)
}
\arguments{
\item{x}{An object produced by the isatpanel function}

\item{plus_t}{Number of time periods for the counterfactual to be displayed (default = 5).}

\item{facet.scales}{To be passed to ggplot2::facet_wrap. Default is "free" (i.e. a separate y axis for each panel group/id). Alternatives are: "fixed", "fixed_y", and "fixed_x".}

\item{title}{Plot title. Must be a character vector.}

\item{zero_line}{Plot a horizontal line at y = 0. Default is FALSE.}

\item{regex_exclude_indicators}{A regex character vector to exclude the inclusion of certain indicators in the plot. Default = NULL. Use with care, experimental.}
}
\value{
A ggplot2 plot that plots an 'isatpanel' object and shows the counterfactuals for each break.
}
\description{
Plot the Counterfactual Path
}
\examples{
\donttest{
data(EU_emissions_road)

# Group specification
EU15 <- c("Austria", "Germany", "Denmark", "Spain", "Finland", "Belgium",
         "France", "United Kingdom", "Ireland", "Italy", "Luxembourg",
         "Netherlands", "Greece", "Portugal", "Sweden")

# Prepare sample and data
EU_emissions_road_short <- EU_emissions_road[
EU_emissions_road$country \%in\% EU15 &
EU_emissions_road$year >= 2000,
]

# Run
result <- isatpanel(
  data = EU_emissions_road_short,
  formula = ltransport.emissions ~ lgdp + I(lgdp^2) + lpop,
  index = c("country", "year"),
  effect = "twoways",
  fesis = TRUE,
  plot = FALSE,
  t.pval = 0.01
)
plot(result)
plot_grid(result)
plot_counterfactual(result)
}
}
