% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoflow_profile.R
\docType{class}
\name{geoflow_profile}
\alias{geoflow_profile}
\title{Geoflow profile class}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an profile
}
\description{
This class models an profile
}
\details{
geoflow_profile
}
\examples{
\dontrun{
  profile <- geoflow_profile$new()
  profile$setId("workflow1")
  profile$setName("Workflow 1")
  profile$setProject("My project")
  profile$setOrganization("My organization")
  provfile$addLogo("https://via.placeholder.com/300x150.png/09f/fff?text=geoflow")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{profile}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{profile id}

\item{\code{name}}{profile name}

\item{\code{project}}{profile project}

\item{\code{organization}}{profile organization}

\item{\code{logos}}{profile logo(s)}

\item{\code{mode}}{mode of execution (Default is "raw")}

\item{\code{options}}{global config options}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-geoflow_profile-new}{\code{geoflow_profile$new()}}
\item \href{#method-geoflow_profile-setId}{\code{geoflow_profile$setId()}}
\item \href{#method-geoflow_profile-setName}{\code{geoflow_profile$setName()}}
\item \href{#method-geoflow_profile-setProject}{\code{geoflow_profile$setProject()}}
\item \href{#method-geoflow_profile-setOrganization}{\code{geoflow_profile$setOrganization()}}
\item \href{#method-geoflow_profile-addLogo}{\code{geoflow_profile$addLogo()}}
\item \href{#method-geoflow_profile-setMode}{\code{geoflow_profile$setMode()}}
\item \href{#method-geoflow_profile-setOption}{\code{geoflow_profile$setOption()}}
\item \href{#method-geoflow_profile-clone}{\code{geoflow_profile$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_profile-new"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_profile-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{geoflow_profile}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_profile$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_profile-setId"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_profile-setId}{}}}
\subsection{Method \code{setId()}}{
Sets profile ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_profile$setId(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{id}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_profile-setName"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_profile-setName}{}}}
\subsection{Method \code{setName()}}{
Sets profile name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_profile$setName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_profile-setProject"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_profile-setProject}{}}}
\subsection{Method \code{setProject()}}{
Sets profile project
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_profile$setProject(project)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{project}}{project}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_profile-setOrganization"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_profile-setOrganization}{}}}
\subsection{Method \code{setOrganization()}}{
Sets profile organization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_profile$setOrganization(organization)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{organization}}{organization}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_profile-addLogo"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_profile-addLogo}{}}}
\subsection{Method \code{addLogo()}}{
Adds a profile organization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_profile$addLogo(logo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{logo}}{logo}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_profile-setMode"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_profile-setMode}{}}}
\subsection{Method \code{setMode()}}{
Sets profile mode
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_profile$setMode(mode)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{profile mode}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_profile-setOption"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_profile-setOption}{}}}
\subsection{Method \code{setOption()}}{
Set global config option
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_profile$setOption(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{option name}

\item{\code{value}}{option value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_profile-clone"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_profile-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_profile$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
