% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDynamicChips.R
\name{checkDynamicChips}
\alias{checkDynamicChips}
\title{checkDymamicChips}
\usage{
checkDynamicChips(
  chipsSF,
  chipSize = 512,
  cellSize = 1,
  doJitter = FALSE,
  jitterSD = 15,
  useSeed = TRUE,
  seed = 42
)
}
\arguments{
\item{chipsSF}{sf object created by makeDynamicChipsSF().}

\item{chipSize}{Size of desired image chips. Default is 512 (512x512 cells)}

\item{cellSize}{Cells size of input data. Default is 1 m.}

\item{doJitter}{Whether or not to add random noise to chip center coordinates. Default is FALSE.}

\item{jitterSD}{If doJitter is TRUE, standard deviation of random positional noise to add in
both the x and y directions. Default is 15 (15 meters).}

\item{useSeed}{Whether or not to use a random seed for added jitter noise. Default is FALSE.}

\item{seed}{Random seed value.}
}
\value{
Dataframe of summary information about image chips.
}
\description{
Generate a dataframe of summary infformation for each chip defined using makeDynamicChipsSF().
}
\details{
Generate set of summary information about each chip defined by makeDynamicChipsSF() including
all the information in the sf object generated by makeDynamicChipsSF() and the number of columns
of cells in the predictor variable raster and mask ("cCntImg" and "cCntMsk"), number of rows
of cells in the predictor variable raster and mask ("rCntImg" and "rCntMsk"), number of input
predictor variables ("bCntImg"), and count of NA pixels in the predictor variable raster and mask
("naCntImg" and "naCntMsk"). This function is used primarily to check the chips prior to attempting
to use them in a training or validation process.
}
