library(testthat)

test_that("rss.prop.simulation works as expected",{
  set.seed(123)
  rss.prop.data=rss.prop.simulation(H=3,nsamp=c(6,6,6),p=0.6)
  expect_s3_class(rss.prop.data,"data.frame")
  expect_equal(colnames(rss.prop.data), c("rank","y"))
  expect_equal(dim(rss.prop.data), c(18,2))
  rss.prop.data.lth <- as.numeric(tapply(rss.prop.data$y,rss.prop.data$rank,length))
  expect_equal(rss.prop.data.lth, c(6,6,6))
  rss.prop.data.mu=mean(tapply(rss.prop.data$y, rss.prop.data$rank, mean))
  expect_equal(round(rss.prop.data.mu,5), c(0.72222))
  
  set.seed(123)
  rss.prop.data=rss.prop.simulation(H=3,nsamp=c(6,10,8),p=0.2)
  expect_s3_class(rss.prop.data,"data.frame")
  expect_equal(colnames(rss.prop.data), c("rank","y"))
  expect_equal(dim(rss.prop.data), c(24,2))
  rss.prop.data.lth <- as.numeric(tapply(rss.prop.data$y,rss.prop.data$rank,length))
  expect_equal(rss.prop.data.lth, c(6,10,8))
  rss.prop.data.mu=mean(tapply(rss.prop.data$y, rss.prop.data$rank, mean))
  expect_equal(round(rss.prop.data.mu,5), c(0.23333))
})

test_that("rss.prop.simulation handles wrong input with error",{
  expect_error(rss.prop.simulation(H=4,nsamp=c(6,10,8),p=0.2),
               "Set size are different with the length of sample allocations")
  expect_error(rss.prop.simulation(H=2,nsamp=c(6,10,8),p=0.2),
               "Set size are different with the length of sample allocations")
  expect_error(rss.prop.simulation(H=3,nsamp=c(6,10,8),p=1.2),
               "Invalid value for p. It must be between 0 and 1.")
})
