library(testthat)

test_that("rss.prop.sampling works as expected",{
  set.seed(123)
  data(iris)
  id=1:nrow(iris)
  X=ifelse(iris$Sepal.Length<5.8,0,1)
  rss.prop.data=rss.prop.sampling(ID=id, X=X, H=3,nsamp=c(6,6,6))
  expect_s3_class(rss.prop.data,"data.frame")
  expect_equal(colnames(rss.prop.data), c("rank","ID"))
  expect_equal(dim(rss.prop.data), c(18,2))
  rss.prop.data.lth <- as.numeric(tapply(rss.prop.data$ID,rss.prop.data$rank,length))
  expect_equal(rss.prop.data.lth, c(6,6,6))
})

test_that("rss.prop.sampling handles wrong input with error",{
  data(iris)
  id=1:nrow(iris)
  expect_error(rss.prop.sampling(ID=id, X=iris$Petal.Length, H=5, nsamp=c(3,5,7)),
               "Set size are different with the length of sample allocations")
  expect_error(rss.prop.sampling(ID=id, X=iris$Petal.Length, H=2, nsamp=c(3,5,7)),
               "Set size are different with the length of sample allocations")
  # Mismatched lengths of ID, X, Y
  expect_error(rss.prop.sampling(ID = id[-1], X = iris$Petal.Length, H = 3, nsamp = c(3, 5, 7)),
               "ID and X must have the same length.")
})
