library(testthat)

test_that("rss.ELR.test works as expected",{
  set.seed(123)
  rss.data<-rss.simulation(H=3,nsamp=c(6,8,10),dist="normal", rho=0.8,delta=0)
  result=rss.ELR.test(data=rss.data, alpha=0.05, mu0=0)
  expect_equal(result$RSS_mean,-0.0527, tolerance = 1e-3)
  expect_equal(result$`-2*log.LR`, 0.1488, tolerance = 1e-3)
  expect_equal(result$p.value, 0.6996, tolerance = 1e-3)
  expect_equal(result$CI, c(-0.3153,0.2204), tolerance = 1e-3)
  expect_warning(rss.ELR.test(data=rss.data, alpha=0.05, mu0=5),
               "Warning: Convergence failed due to extreme deviation, leading to infinite LRT and p-value = 0.")
})

test_that("rss.ELR.test handles wrong input with error",{
  rss.data=rss.simulation(H=3,nsamp=c(6,7,8),dist="normal", rho=0.8,delta=0)
  expect_error(rss.ELR.test(data=rss.data, alpha=1.1, mu0=0),
               "alpha is out of bound.")
  expect_error(rss.ELR.test(data=rss.data[,1], alpha=0.05, mu0=0),
               "The input data must contain 'rank' and 'y' variables.")
  expect_error(rss.ELR.test(data=rss.data[,2], alpha=0.05, mu0=0),
               "The input data must contain 'rank' and 'y' variables.")
})
