% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rss.simulation.R
\name{rss.simulation}
\alias{rss.simulation}
\title{Generate example ranked set samples}
\usage{
rss.simulation(H, nsamp, dist, rho, delta)
}
\arguments{
\item{H}{The RSS set size.}

\item{nsamp}{A numeric vector specifying the sample allocation for each stratum.}

\item{dist}{A character string specifying the distribution to generate ranked set samples. Must be one of "normal", "t", or "lognorm".}

\item{rho}{The ranking quality or accuracy indicating the correlation between outcome and auxiliary variable. Must be between 0 and 1 for imperfect ranking, or exactly 1 for perfect ranking.}

\item{delta}{The true population mean.}
}
\value{
\item{rank}{The rank information assigned to each sample.}
\item{y}{The generated ranked set samples based on the specified distribution.}
}
\description{
The rss.simulation function generates ranked set samples by simulating data from a specified population distribution ('normal', 't', or 'lognorm") with options to adjust the mean (delta) and control ranking quality (rho).
}
\details{
This function simulates balanced or unbalanced RSS sampling. The length of the sample allocation vector (nsamp) must match the set size (H). The dist parameter allows users to select one of three population distributions: 'normal', 't', or 'lognormal'. Additionally, the delta parameter adjusts the population mean. The rho parameter controls ranking accuracy by representing the correlation between the outcome and an auxiliary variable. A value of rho = 1 indicates perfect ranking, while values between 0 and 1 represent varying levels of imperfect ranking using a linear ranking model which is defined as \eqn{X_i = Y_i + \epsilon_i} for \eqn{i=1,2,\cdots, n} where \eqn{\epsilon_i} are independent random variables from \eqn{N(0,\sigma^2)}. The variance \eqn{\sigma^2} is set to obtain a specific correlation between the outcome (Y) and auxiliary (X) variables.
}
\examples{
## Balanced RSS with a set size 3 and equal sample sizes of 6 for each stratum,
## using imperfect ranking from a normal distribution with a mean of 0.
rss.data=rss.simulation(H=3,nsamp=c(6,6,6),dist="normal", rho=0.8,delta=0)

## Unbalanced RSS with a set size 3 and different sample sizes of 6, 10, and 8 for each stratum,
## using perfect ranking from a t distribution with a mean of 0.
rss.data=rss.simulation(H=3,nsamp=c(6,10,8),dist="t", rho=1,delta=0)

# Check the structure of the RSS data
colnames(rss.data) # Should include "y" and "rank"
head(rss.data$y)
head(rss.data$rank)

}
