% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rss.design.R
\name{rss.design}
\alias{rss.design}
\title{Calculate efficient sample allocations for ranked set sampling}
\usage{
rss.design(data = NULL, H = NULL, org.n = NULL, var.h = NULL, prop = FALSE)
}
\arguments{
\item{data}{A numeric data frame of ranked set samples with columns 'rank' for ranks and 'y' for data values.}

\item{H}{The set size}

\item{org.n}{The initial sample allocation vector}

\item{var.h}{A vector of strata variances}

\item{prop}{logical indicating the sampling design for proportions}
}
\value{
\item{original.n}{The initial RSS sample allocation.}
\item{Integer.Neyman}{The integer Neyman allocation.}
\item{Adj.Neyman}{The adjusted Neyman allocation.}
\item{LRC.allocation}{The local ratio consistent allocation.}
\item{Neyman.proportion}{The optimal Neyman allocation for proportions.}
}
\description{
The rss.design function calculates three efficient sample allocations for each stratum using given either initial RSS data or design. These allocations include Integer Neyman, adjusted Neyman, and local ratio consistent allocations for quantitative data and optimal Neyman for binary data to improve sampling efficiency.
}
\details{
This function offers a systematic approach for determining efficient sample allocations in unbalanced RSS. Given either an initial RSS data or design (but not both), the function optimizes sample allocation to ensure higher efficiency compared to the initial RSS design. For quantitative data, the function calculates the integer Neyman allocation proposed by Wright (2012), as well as, the adjusted Neyman allocation and local ratio consistent (LRC) allocation introduced by Ahn et al. (2022), which guarantees efficiency improvements compared to SRS and BRSS. For binary data, it computes the optimal Neyman allocation by Chen et al. (2006).
}
\examples{
## Unbalanced RSS with a set size 3 and different sample sizes of 3, 10, and 5 for each stratum,
## using perfect ranking from a t distribution with a mean of 0.
rss.data=rss.simulation(H=3,nsamp=c(3,10,5), dist="t", rho=1,delta=0)

# Check the structure of the RSS data
colnames(rss.data) # Should include "y" and "rank"
head(rss.data$y)
head(rss.data$rank)

## RSS allocation calculation for a given pilot RSS data
rss.design(rss.data)


## Unbalanced RSS with a set size 3 and different sample sizes of 10, 15, and 15 for each stratum,
## using perfect ranking for proportions with a population proportion of 0.5.
rss.prop.data=rss.prop.simulation(H=3,nsamp=c(10,15,20),p=0.5)

## RSS allocation calculation for a given pilot RSS binary data
rss.design(rss.prop.data,prop=TRUE)

}
\references{
S. Ahn, X. Wang, and J. Lim. (2022) Efficient sample allocation by local adjustment for unbalanced ranked set sampling. In Recent Advances on Sampling Methods and Educational Statistics, Springer.

H. Chen, E.A. Stasny, and D.A. Wolfe. (2006). Unbalanced ranked set sampling for estimating a population proportion. Biometrics, 62(1), 150-158.

T. Wright (2012) The equivalence of Neyman optimum allocation for sampling and equal proportions for apportioning the U.S. house of representatives. The American Statistician, 66(4), 217-224.
}
\seealso{
\code{\link{rss.simulation}}: used for simulating Ranked Set Samples (RSS), which can serve as input.

\code{\link{rss.sampling}}: used for sampling Ranked Set Samples (RSS) from a population data set, providing input data.
}
