% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects.R
\name{get_projects}
\alias{get_projects}
\title{Retrieve Highbond Projects - Projects}
\usage{
get_projects(
  auth,
  project_id = NULL,
  fields = NULL,
  pagesize = 50,
  waittime = 0.2
)
}
\arguments{
\item{auth}{Highbond authentication credentials, created from \code{\link{setup_highbond}}}

\item{project_id}{Project ID number. \code{NULL} will default to all items.}

\item{fields}{OPTIONAL. A character vector each field requested within the
project. NULL will default to all fields.}

\item{pagesize}{Defaults to 50. Maximum is 100.}

\item{waittime}{Time in seconds to wait between requests.}
}
\value{
A tibble of projects
}
\description{
Downloads the primary details of one or all projects
}
\details{
Fields allowed: name, state, status, created_at, updated_at,
description, background, budget, position, certification,
control_performance, risk_assurance, management_response, max_sample_size,
number_of_testing_rounds, opinion, opinion_description, purpose, scope,
start_date, target_date, tag_list, project_type, entities
}
\examples{
\dontrun{
projects <- get_projects(auth)
projects <- get_projects(auth, fields = c('name', 'state', 'status'))
}
}
