% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedMeanLearner.R
\name{weightedMeanLearner}
\alias{weightedMeanLearner}
\title{The weighted mean meta-learner}
\usage{
weightedMeanLearner(x, y, weighted = TRUE, perf = NULL, na_rm = FALSE)
}
\arguments{
\item{x}{\code{data.frame} \cr
Modality-specific predictions. Each column of the \code{data.frame} content the predictions
a specific learner.}

\item{y}{\code{vector} \cr
True target values. If classification, either binary or two level factor variable.}

\item{weighted}{\code{boolean} \cr
If TRUE, a weighted sum is computed. As default, weights are estimated based on Brier Score
for classification setting and mean squared error for regression. Otherwise, use argument
\code{perf} below to specify the function to use estimate learner performance.}

\item{perf}{\code{function} \cr
Function to compute layer-specific performance of learners. If NULL, the Brier Score (classification) or a mean squared error (regression) is used by default as performance measure.
Otherwise, the performance function must accept two parameters: \code{observed} (observed values) and \code{predicted} (predicted values).}

\item{na_rm}{\code{boolean} \cr
Should missing values be removed when computing the weights?}
}
\value{
Object of class \code{weightedMeanLearner} with the vector of estimated weights pro layer.\cr
}
\description{
Modality-specific learner are assessed and weighted based on their predictions. This function is intended to be (internally) used as meta-learner in fuseMLR.
}
\examples{
set.seed(20240624L)
x = data.frame(x1 = runif(n = 50L, min = 0, max = 1),
               x2 = runif(n = 50L, min = 0, max = 1))
y = sample(x = 0L:1L, size = 50L, replace = TRUE)
my_model = weightedMeanLearner(x = x, y = y)

}
