% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_importance_xgboost.R
\name{extract_importance_xgboost}
\alias{extract_importance_xgboost}
\title{Extract the learner-specific importance from an xgboost object}
\usage{
extract_importance_xgboost(fit = NULL, feature_names = "", coef = 0)
}
\arguments{
\item{fit}{the \code{xgboost} object.}

\item{feature_names}{the feature names}

\item{coef}{the Super Learner coefficient associated with the learner.}
}
\value{
a tibble, with columns \code{algorithm} (the fitted algorithm),
\code{feature} (the feature), \code{importance} (the algorithm-specific
extrinsic importance of the feature), \code{rank} (the feature importance
rank, with 1 indicating the most important feature), and \code{weight}
(the algorithm's weight in the Super Learner)
}
\description{
Extract the individual-algorithm extrinsic importance from an xgboost object,
along with the importance rank.
}
\examples{
data("biomarkers")
# subset to complete cases for illustration
cc <- complete.cases(biomarkers)
dat_cc <- biomarkers[cc, ]
# use only the mucinous outcome, not the high-malignancy outcome
y <- dat_cc$mucinous
x <- as.matrix(dat_cc[, !(names(dat_cc) \%in\% c("mucinous", "high_malignancy"))])
feature_nms <- names(x)
set.seed(20231129)
xgbmat <- xgboost::xgb.DMatrix(data = x, label = y)
# get the fit, using a small number of rounds for illustration only
fit <- xgboost::xgb.train(
  data = xgbmat, nrounds = 10,
  params = list("objective" = "binary:logistic",
                "nthread" = 1, "max_depth" = 1)
)
# extract importance
importance <- extract_importance_xgboost(fit = fit, feature_names = feature_nms)
importance

}
