#' Amputee Combined Gait Data
#'
#' Kinematic data for 18 individuals with unilateral above-knee amputations and 42 healthy controls.
#' Each entry contains 18 kinematic variables measured at 1% intervals over the full gait cycle. 
#' control data precedes amputee data. Amputee data from Hood et al. (2020); control data from
#' Fukuchi et al. (2018).
#' @format A list containing the 18 kinematic variables with each list containing a data.frame with N rows and T variables, where N is 
#' the total number of subjects and T is the total number of time points. 
#' \describe{
#'   \item{Left Pelvis Angles D2}{numeric data.frame with N rows and T variables}
#'   \item{Left Pelvis Angles D1}{numeric data.frame with N rows and T variables}
#'   \item{Left Pelvis Angles D3}{numeric data.frame with N rows and T variables}
#'   \item{Left Hip Angles D2}{numeric data.frame with N rows and T variables}
#'   \item{Left Hip Angles D1}{numeric data.frame with N rows and T variables}
#'   \item{Left Hip Angles D3}{numeric data.frame with N rows and T variables}
#'   \item{Left Knee Angles}{numeric data.frame with N rows and T variables}
#'   \item{Left Ankle Angle}{numeric data.frame with N rows and T variables}
#'   \item{Left Foot Progression Angle}{numeric data.frame with N rows and T variables}
#'   \item{Right Pelvis Angles D2}{numeric data.frame with N rows and T variables}
#'   \item{Right Pelvis Angles D1}{numeric data.frame with N rows and T variables}
#'   \item{Right Pelvis Angles D3}{numeric data.frame with N rows and T variables}
#'   \item{Right Hip Angles D2}{numeric data.frame with N rows and T variables}
#'   \item{Right Hip Angles D1}{numeric data.frame with N rows and T variables}
#'   \item{Right Hip Angles D3}{numeric data.frame with N rows and T variables}
#'   \item{Right Knee Angles}{numeric data.frame with N rows and T variables}
#'   \item{Right Ankle Angle}{numeric data.frame with N rows and T variables}
#'   \item{Right Foot Progression Angle}{numeric data.frame with N rows and T variables}
#' }
#' @examples
#' # Load the Data
#' data(A_Data)
#' @source Internal gait study
"A_Data"

#' Amputee Left-Side Gait Data
#'
#' Kinematic data for 18 individuals with unilateral above-knee amputations (left side only) and 42 healthy controls.
#' Each entry includes pelvic, hip, knee, ankle, and foot angles, sampled at 1% intervals
#' over the full gait cycle. Amputee data from Hood et al. (2020); control data from Fukuchi et al. (2018).
#' @format A list containing the 9 kinematic variables with each list containing a data.frame with N rows and T variables, where N is 
#' the total number of subjects and T is the total number of time points. 
#' \describe{
#'   \item{Left Pelvis Angles D2}{numeric data.frame with N rows and T variables}
#'   \item{Left Pelvis Angles D1}{numeric data.frame with N rows and T variables}
#'   \item{Left Pelvis Angles D3}{numeric data.frame with N rows and T variables}
#'   \item{Left Hip Angles D2}{numeric data.frame with N rows and T variables}
#'   \item{Left Hip Angles D1}{numeric data.frame with N rows and T variables}
#'   \item{Left Hip Angles D3}{numeric data.frame with N rows and T variables}
#'   \item{Left Knee Angles}{numeric data.frame with N rows and T variables}
#'   \item{Left Ankle Angle}{numeric data.frame with N rows and T variables}
#'   \item{Left Foot Progression Angle}{numeric data.frame with N rows and T variables}
#' }
#' @examples
#' # Load the Data
#' data(A_DataL)
"A_DataL"

#' Amputee Right-Side Gait Data
#'
#' Kinematic data for 18 individuals with right-side above-knee amputations and 42 healthy controls.
#' Includes pelvic, hip, knee, ankle, and foot angles, sampled at 1% intervals
#' over the full gait cycle. Amputee data from Hood et al. (2020); control data from Fukuchi et al. (2018).
#' @format A list containing the 9 kinematic variables with each list containing a data.frame with N rows and T variables, where N is 
#' the total number of subjects and T is the total number of time points. 
#' \describe{
#'   \item{Right Pelvis Angles D2}{numeric data.frame with N rows and T variables}
#'   \item{Right Pelvis Angles D1}{numeric data.frame with N rows and T variables}
#'   \item{Right Pelvis Angles D3}{numeric data.frame with N rows and T variables}
#'   \item{Right Hip Angles D2}{numeric data.frame with N rows and T variables}
#'   \item{Right Hip Angles D1}{numeric data.frame with N rows and T variables}
#'   \item{Right Hip Angles D3}{numeric data.frame with N rows and T variables}
#'   \item{Right Knee Angles}{numeric data.frame with N rows and T variables}
#'   \item{Right Ankle Angle}{numeric data.frame with N rows and T variables}
#'   \item{Right Foot Progression Angle}{numeric data.frame with N rows and T variables}
#' }
#'  @examples
#' # Load the Data
#' data(A_DataR)
"A_DataR"

#' Metadata for Amputee Subjects
#'
#' @format A data frame with the following variables:
#' \describe{
#'   \item{Subject.Code}{Unique identifier for each subject (e.g., TF01, TF02).}
#'   \item{Age.yrs.}{Age of the subject in years.}
#'   \item{Gender}{Biological sex (e.g., Male, Female).}
#'   \item{Mass.kg.}{Body mass in kilograms.}
#'   \item{Height.m.}{Height in meters.}
#'   \item{Amputation.side}{Side of amputation (Left or Right).}
#'   \item{Etiology}{Cause of amputation (e.g., Traumatic, Infection, Dysvascular).}
#'   \item{Age.of.Amputation..yrs.}{Age at which the subject underwent amputation (years).}
#'   \item{K.Level}{Medicare Functional Classification Level (e.g., K2, K3), indicating the subject’s mobility level.}
#'   \item{Prescribed.Prosthesis.Knee}{Type/model of the prosthetic knee prescribed (e.g., C-Leg Obk, Plie FI).}
#'   \item{Prescribed.Prosthesis.Ankle}{Type/model of the prosthetic ankle prescribed (e.g., AllPro FI, Triton Obk).}
#'   \item{Socket.Suspension}{Suspension mechanism used for the prosthetic socket (e.g., Suction, Lanyard, Pin Lock).}
#'   \item{Training.....}{Indicates whether the subject had gait training and, if so, how many sessions (e.g., ``Yes (2)'', ``No'').}
#'   \item{Hand.rails.}{Indicates whether hand-rails were used during gait assessment (e.g., ``Yes, All'', ``No'').}
#' }
#' @examples
#' # Load the Data
#' data("A_data_info")
"A_data_info"

#' Parkinson Combined Gait Data
#'
#' Kinematic data for Parkinson's subjects.The PD dataset is publicly accessible, as detailed in Shida, T. K. F., Costa, T. M., de Oliveira, 
#' C. E. N., de Castro Treza, R., Hondo, S. M., Los Angeles, E., ... & Coelho, D. B. (2023).. It includes data from 21
#' right-handed idiopathic PD individuals. Measurements are taken at 1% intervals throughout the entire 100% gait cycle.
#' @format A list containing the 18 kinematic variables with each list containing a data.frame with N rows and T variables, where N is 
#' the total number of subjects and T is the total number of time points. 
#' \describe{
#'   \item{Left Pelvis Angles D2}{numeric data.frame with N rows and T variables}
#'   \item{Left Pelvis Angles D1}{numeric data.frame with N rows and T variables}
#'   \item{Left Pelvis Angles D3}{numeric data.frame with N rows and T variables}
#'   \item{Left Hip Angles D2}{numeric data.frame with N rows and T variables}
#'   \item{Left Hip Angles D1}{numeric data.frame with N rows and T variables}
#'   \item{Left Hip Angles D3}{numeric data.frame with N rows and T variables}
#'   \item{Left Knee Angles}{numeric data.frame with N rows and T variables}
#'   \item{Left Ankle Angle}{numeric data.frame with N rows and T variables}
#'   \item{Left Foot Progression Angle}{numeric data.frame with N rows and T variables}
#'   \item{Right Pelvis Angles D2}{numeric data.frame with N rows and T variables}
#'   \item{Right Pelvis Angles D1}{numeric data.frame with N rows and T variables}
#'   \item{Right Pelvis Angles D3}{numeric data.frame with N rows and T variables}
#'   \item{Right Hip Angles D2}{numeric data.frame with N rows and T variables}
#'   \item{Right Hip Angles D1}{numeric data.frame with N rows and T variables}
#'   \item{Right Hip Angles D3}{numeric data.frame with N rows and T variables}
#'   \item{Right Knee Angles}{numeric data.frame with N rows and T variables}
#'   \item{Right Ankle Angle}{numeric data.frame with N rows and T variables}
#'   \item{Right Foot Progression Angle}{numeric data.frame with N rows and T variables}
#' }
#' @examples
#' # Load the Data
#' data(P_Data)
"P_Data"

#' Metadata for Parkinson Subjects
#'
#' @format A data frame with the following variables:
#' \describe{
#'   \item{ID}{Subject identifier (e.g., SUB01).}
#'   \item{Gender}{Sex of the subject (e.g., M/F).}
#'   \item{Age}{Age in years.}
#'   \item{Height..cm.}{Height in centimeters.}
#'   \item{Weight..kg.}{Body weight in kilograms.}
#'   \item{BMI..kg.m2.}{Body mass index in kg/m\eqn{^2}.}
#'   \item{Ortho.Prosthesis}{Use of orthotic and/or prosthetic device.}
#'   \item{Years.of.formal.study}{Years of formal education completed.}
#'   \item{Disease.duration..years.}{Time since Parkinson’s disease diagnosis (years).}
#'   \item{L.Dopa.equivalent.units..mg.day.1.}{Levodopa equivalent daily dose (mg/day).}
#'   \item{FoG.group}{Classification based on freezing of gait (e.g., freezer/non-freezer).}
#'   \item{FoG.Q..score.}{Freezing of Gait Questionnaire total score.}
#'   \item{Initial.symptoms}{Initial Parkinson’s disease symptoms reported.}
#'   \item{Is.there.a.family.history.of.PD..Who.}{Family history of Parkinson’s disease and relationship.}
#'   \item{Do.you.feel.improvement.after.using.the.antiparkinsonian.medicine.}{Self-reported improvement after antiparkinsonian medication.}
#'   \item{Have.you.ever.had.any.type.of.surgery..Which.}{History of surgery and type.}
#'   \item{Any.rehabilitation.or.physical.activity.}{Participation in rehabilitation or regular physical activity.}
#'   \item{Other.disease..cardiovascular..bone..etc..}{Reported comorbid conditions (cardiovascular, bone, etc.).}
#'   \item{Handedness}{Dominant hand.}
#'   \item{ON...Hoehn...Yahr}{Hoehn and Yahr stage in the ON-medication state.}
#'   \item{ON...MoCA}{Montreal Cognitive Assessment (MoCA) score in the ON-medication state.}
#'   \item{ON...mini.BESTest}{Mini-BESTest balance score in the ON-medication state.}
#'   \item{ON...FES.I}{Falls Efficacy Scale–International (FES-I) score in the ON-medication state.}
#'   \item{ON...UPDRS.II}{UPDRS Part II (activities of daily living) total score in the ON-medication state.}
#'   \item{ON...UPDRS.II...walking}{UPDRS Part II walking item score in the ON-medication state.}
#'   \item{ON...UPDRS.III}{UPDRS Part III (motor examination) total score in the ON-medication state.}
#'   \item{ON...UPDRS.III...rigidity}{UPDRS Part III rigidity item score in the ON-medication state.}
#'   \item{ON...UPDRS.III...walking}{UPDRS Part III gait/walking item score in the ON-medication state.}
#'   \item{ON...PIGD.or.TD}{Motor phenotype in ON state: PIGD (postural instability/gait difficulty) or tremor-dominant (TD).}
#'   \item{ON...UPDRS.III.asymmetry}{Motor asymmetry index from UPDRS Part III in the ON-medication state.}
#'   \item{ON...Stroop.I.time..s.}{Completion time (seconds) for Stroop Test condition I in the ON-medication state.}
#'   \item{ON...Stroop.I.error}{Number of errors in Stroop Test condition I in the ON-medication state.}
#'   \item{ON...Stroop.II.time..s.}{Completion time (seconds) for Stroop Test condition II in the ON-medication state.}
#'   \item{ON...Stroop.II.error}{Number of errors in Stroop Test condition II in the ON-medication state.}
#'   \item{ON...Stroop.III.time..s.}{Completion time (seconds) for Stroop Test condition III (interference) in the ON-medication state.}
#'   \item{ON...Stroop.III.error}{Number of errors in Stroop Test condition III in the ON-medication state.}
#'   \item{ON...TMTA.time..s.}{Completion time (seconds) for Trail Making Test Part A in the ON-medication state.}
#'   \item{ON...TMTA.error}{Number of errors in Trail Making Test Part A in the ON-medication state.}
#'   \item{ON...TMTB.time.s.}{Completion time (seconds) for Trail Making Test Part B in the ON-medication state.}
#'   \item{ON...TMTB.error}{Number of errors in Trail Making Test Part B in the ON-medication state.}
#'   \item{OFF...Hoehn...Yahr}{Hoehn and Yahr stage in the OFF-medication state.}
#'   \item{OFF...MoCA}{Montreal Cognitive Assessment (MoCA) score in the OFF-medication state.}
#'   \item{OFF...mini.BESTest}{Mini-BESTest balance score in the OFF-medication state.}
#'   \item{OFF...FES.I}{Falls Efficacy Scale–International (FES-I) score in the OFF-medication state.}
#'   \item{OFF...UPDRS.II}{UPDRS Part II (activities of daily living) total score in the OFF-medication state.}
#'   \item{OFF...UPDRS.II...walking}{UPDRS Part II walking item score in the OFF-medication state.}
#'   \item{OFF...UPDRS.III}{UPDRS Part III (motor examination) total score in the OFF-medication state.}
#'   \item{OFF...UPDRS.III...rigidity}{UPDRS Part III rigidity item score in the OFF-medication state.}
#'   \item{OFF...UPDRS.III...walking}{UPDRS Part III gait/walking item score in the OFF-medication state.}
#'   \item{OFF...PIGD.or.TD}{Motor phenotype in OFF state: PIGD or tremor-dominant (TD).}
#'   \item{OFF...UPDRS.III.asymmetry}{Motor asymmetry index from UPDRS Part III in the OFF-medication state.}
#'   \item{OFF...Stroop.I.time..s.}{Completion time (seconds) for Stroop Test condition I in the OFF-medication state.}
#'   \item{OFF...Stroop.I.error}{Number of errors in Stroop Test condition I in the OFF-medication state.}
#'   \item{OFF...Stroop.II.time..s.}{Completion time (seconds) for Stroop Test condition II in the OFF-medication state.}
#'   \item{OFF...Stroop.II.error}{Number of errors in Stroop Test condition II in the OFF-medication state.}
#'   \item{OFF...Stroop.III.time..s.}{Completion time (seconds) for Stroop Test condition III (interference) in the OFF-medication state.}
#'   \item{OFF...Stroop.III.error}{Number of errors in Stroop Test condition III in the OFF-medication state.}
#'   \item{OFF...TMTA.time..s.}{Completion time (seconds) for Trail Making Test Part A in the OFF-medication state.}
#'   \item{OFF...TMTA.error}{Number of errors in Trail Making Test Part A in the OFF-medication state.}
#'   \item{OFF...TMTB.time.s.}{Completion time (seconds) for Trail Making Test Part B in the OFF-medication state.}
#'   \item{OFF...TMTB.error}{Number of errors in Trail Making Test Part B in the OFF-medication state.}
#'   \item{FGDI}{Freezing of Gait Diagnostic Interview score.}
#' }
#' @examples
#' # Load the Data
#' data("P_data_info")
"P_data_info"
