% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_faunabr.R
\name{load_faunabr}
\alias{load_faunabr}
\title{Load Brazilian Fauna database}
\usage{
load_faunabr(data_dir, data_version = "latest",
                    type = "short", verbose = TRUE, encoding = "UTF-8")
}
\arguments{
\item{data_dir}{(character) the same directory used to save the data
downloaded from Brazilian Fauna using the \link{get_faunabr} function.}

\item{data_version}{(character) the version of Brazilian Fauna database to
be loaded. It can be "latest", which will load the latest version
available; or another specified version, for example "1.2".
Default = "latest".}

\item{type}{(character) it determines the number of columns that will be
loaded. It can be "short" or "complete". Default = "short". See details.}

\item{verbose}{(logical) Whether to display messages during function
execution. Set to TRUE to enable display, or FALSE to run silently.
Default = TRUE.}

\item{encoding}{(character) the declared encodings for special characters.
Character strings in R can be declared to be encoded in "latin1" or "UTF-8".
Default: "UTF-8".}
}
\value{
A data.frame with the specified version (Default is the latest
available) of the Brazilian Fauna database. This data.frame is necessary to
run most of the functions of the package.
}
\description{
Load Brazilian Fauna database
}
\details{
The parameter type accepts two arguments. If type = short, it will load a
data.frame with the 20 columns needed to run the other functions of the
package: species, subspecies, scientificName, validName, kingdom, phylum,
class, order, family, genus, lifeForm, habitat, states, countryCode, origin,
taxonomicStatus, nomenclaturalStatus, vernacularName, and taxonRank.
If type = complete, it will load a data.frame with all 31 variables available
in Brazilian Fauna database.
}
\examples{
\dontrun{
#Creating a folder in a temporary directory
#Replace 'file.path(tempdir(), "faunabr")' by a path folder to be create in
#your computer
my_dir <- file.path(file.path(tempdir(), "faunabr"))
dir.create(my_dir)
#Download, merge and save data
get_fauna(output_dir = my_dir, data_version = "latest", overwrite = TRUE,
            verbose = TRUE)
#Load data
df <- load_faunabr(data_dir = my_dir, data_version = "latest",
                   type = "short")
}
}
\references{
Brazilian Zoology Group. Catálogo Taxonômico da Fauna do Brasil. Available at:
https://ipt.jbrj.gov.br/jbrj/resource?r=catalogo_taxonomico_da_fauna_do_brasil
}
