% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homer.R
\name{run_homer}
\alias{run_homer}
\title{Perform HOMER Motif Enrichment Analysis using DE Genomic Positions}
\usage{
run_homer(
  de,
  k,
  positions,
  genome = "hg19",
  subset = function(postmean, lpval, lfsr, rank, quantile) lfsr < 0.05,
  homer.exec = "findMotifsGenome.pl",
  out.dir = tempdir(),
  homer.options = "-len 8,10,12 -size 200 -mis 2 -S 25 -p 1 -h",
  verbose = TRUE
)
}
\arguments{
\item{de}{An object of class \dQuote{topic_model_de_analysis},
usually the result of running \code{\link{de_analysis}}.}

\item{k}{Use the DE analysis results for this topic.}

\item{positions}{A table of genomic positions corresponding to rows
of the \code{de_analysis} results. Specifically, it should a data
frame with four columns: \dQuote{chr}, chromosome name or number;
\dQuote{start}, start position of genomic feature; \dQuote{end},
end position of genomic feature; and \dQuote{name}, the name of the
genomic feature. If not specified, the genomic positions will be
extracted from the row names of \code{de$postmean}, in which the
row names are expected to be of the form \code{chr_start_end}. The
genomic positions will be written to a BED file (see
\url{https://genome.ucsc.edu/FAQ/FAQformat.html} for more
information about BED files).}

\item{genome}{The genome parameter passed to
\code{findMotifsGenome.pl}.}

\item{subset}{Describe input argument "subset" here.}

\item{homer.exec}{The name or file path of the HOMER
\code{findMotifsGenome.pl} excutable.}

\item{out.dir}{The positions BED file and HOMER results are written
to this directory.}

\item{homer.options}{Character string used to override default
\code{findMotifsGenome.pl} options.}

\item{verbose}{When \code{verbose = TRUE}, progress information is
printed to the console.}
}
\value{
A data frame containing the motif enrichment results. It
  is created from the \code{knownResults.txt} HOMER output.
}
\description{
Run HOMER motif finding algorithm
  (\code{findMotifsGenome.pl}) to identify motifs enriched for
  differentially expressed (DE) genomic positions. See
  \url{http://homer.ucsd.edu} for more information.
}
\references{
Heinz, S., Benner, C., Spann, N., Bertolino, E., Lin, Y. C., Laslo,
P., Cheng, J. X., Murre, C., Singh, H. and Glass, C. K. (2010).
Simple combinations of lineage-determining transcription factors
prime cis-regulatory elements required for macrophage and B cell
identities. \emph{Molecular Cell} \bold{38}, 576-589.
}
