% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{PlymouthOzone}
\alias{PlymouthOzone}
\title{Ozone levels at Plymouth, UK}
\format{
\code{PlymouthOzone} is a data frame with 9862 rows and the 3 variables:
\itemize{
\item \code{Date}: with class \code{"Date"} in the format \code{YYYY-MM-DD}.
\item \code{Year}: Values in 1998-2024.
\item \code{Ozone}: daily maximum ozone level in \eqn{\mu}g/m\eqn{^3}.
}
}
\source{
The Department for Environment Food and Rural Affair (DEFRA).
The Plymouth Centre monitoring site at
the \href{https://uk-air.defra.gov.uk/}{UK-AIR} database
\href{https://uk-air.defra.gov.uk/data/data_selector}{Data Selector}.
}
\usage{
PlymouthOzone
}
\description{
Daily maximum ozone levels at Plymouth in London (UK) for the years
1998-2024 inclusive.
}
\examples{
head(PlymouthOzone)

# Time series plot of annual maxima ozone levels
plot(PlymouthOzone$Date, PlymouthOzone$Ozone, xlab = "year",
     ylab = "ozone (micrograms / metre cubed)", pch = 16)
}
\seealso{
\code{\link{PlymouthOzoneMaxima}} for the annual maxima and numbers of
missing values per year.
}
\keyword{datasets}
