% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergmito_surface.R
\name{plot.ergmito}
\alias{plot.ergmito}
\title{Function to visualize the optimization surface}
\usage{
\method{plot}{ergmito}(
  x,
  y = NULL,
  domain = NULL,
  plot. = TRUE,
  par_args = list(),
  image_args = list(),
  breaks = 20L,
  extension = 4L,
  params_labs = stats::setNames(names(coef(x)), names(coef(x))),
  ...
)
}
\arguments{
\item{x}{An object of class \link{ergmito}.}

\item{y, ...}{Ignored.}

\item{domain}{A list.}

\item{plot.}{Logical. When \code{TRUE} (default), the function will call \link[graphics:image]{graphics::image}
and plot all possible combination of parameters.}

\item{par_args}{Further arguments to be passed to \link[graphics:par]{graphics::par}}

\item{image_args}{Further arguments to be passed to \link[graphics:image]{graphics::image}}

\item{breaks}{Integer scalar. Number of splits per dimension.}

\item{extension}{Numeric. Range value of the function.}

\item{params_labs}{Named vector. Alternative labels for the parameters. It
should be in the form of \code{c("orignial name" = "new name")}.}
}
\value{
A list of length \code{choose(length(object$coef), 2)} (all possible
combinations of pairs of parameters), each with the following elements:
\itemize{
\item \code{z} A matrix
\item \code{z} A vector
\item \code{y} A vector
\item \code{xlab} A string. Name of the ERGM parameter in the x-axis.
\item \code{ylab} A string. Name of the ERGM parameter in the y-axis.
}

The list is returned invisible.
}
\description{
General diagnostics function. This function allows to visualize the surface
to be maximize at around a particular point.
}
\details{
It calculates the surface coordinates for each pair of parameters included
in the ERGMito.
}
\examples{

set.seed(12)
x <- rbernoulli(c(4, 4, 5))

ans <- ergmito(x ~ edges + balance)

plot(ans)

}
\seealso{
The \link{ergmito} function.
}
