% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.r
\name{documentation}
\alias{documentation}
\title{documentation}
\arguments{
\item{alpha}{How much weight to give to relative abundances; a value
between 0 and 1, inclusive. Setting \code{alpha=1} is equivalent to
\code{normalized_unifrac()}.}

\item{counts}{A numeric matrix of count data where each column is a
feature, and each row is a sample. Any object coercible with
\code{as.matrix()} can be given here, as well as \code{phyloseq}, \code{rbiom},
\code{SummarizedExperiment}, and \code{TreeSummarizedExperiment} objects. For
optimal performance with very large datasets, see the guide in
\code{vignette('performance')}.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}

\item{cutoff}{The maximum number of observations to consider "rare".
Default: \code{10}.}

\item{digits}{Precision of the returned values, in number of decimal
places. E.g. the default \code{digits=3} could return \code{6.392}.}

\item{pairs}{Which combinations of samples should distances be
calculated for? The default value (\code{NULL}) calculates all-vs-all.
Provide a numeric or logical vector specifying positions in the
distance matrix to calculate. See examples.}

\item{power}{Scaling factor for the magnitude of differences between
communities (\eqn{p}). Default: \code{1.5}}

\item{pseudocount}{The value to add to all counts in \code{counts} to prevent
taking \code{log(0)} for unobserved features. The default, \code{NULL}, selects
the smallest non-zero value in \code{counts}.}

\item{norm}{Normalize the incoming counts. Options are:
\describe{
\item{\code{norm = "percent"} - }{ Relative abundance (sample abundances sum to 1). }
\item{\code{norm = "binary"}  - }{ Unweighted presence/absence (each count is either 0 or 1). }
\item{\code{norm = "clr"}     - }{ Centered log ratio. }
\item{\code{norm = "none"}    - }{ No transformation. }
}
Default: \code{'percent'}, which is the expected input for these formulas.}

\item{margin}{If your samples are in the matrix's rows, set to \code{1L}. If
your samples are in columns, set to \code{2L}. Ignored when \code{counts} is a
\code{phyloseq}, \code{rbiom}, \code{SummarizedExperiment}, or
\code{TreeSummarizedExperiment} object. Default: \code{1L}}

\item{tree}{A \code{phylo}-class object representing the phylogenetic tree for
the OTUs in \code{counts}. The OTU identifiers given by \code{colnames(counts)}
must be present in \code{tree}. Can be omitted if a tree is embedded with
the \code{counts} object or as \code{attr(counts, 'tree')}.}
}
\description{
documentation
}
\keyword{internal}
