% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkValLabels.R
\name{checkEmptyValLabels}
\alias{checkEmptyValLabels}
\alias{checkMissingValLabels}
\title{Check Value Labels}
\usage{
checkEmptyValLabels(
  GADSdat,
  vars = namesGADS(GADSdat),
  valueRange = NULL,
  output = c("list", "data.frame")
)

checkMissingValLabels(
  GADSdat,
  vars = namesGADS(GADSdat),
  classes = c("integer"),
  valueRange = NULL,
  output = c("list", "data.frame")
)
}
\arguments{
\item{GADSdat}{A \code{GADSdat} object.}

\item{vars}{Character vector with the variable names to which \code{checkValLabels()} should be applied.}

\item{valueRange}{[optional] Numeric vector of length 2: In which range should numeric values be checked?
If specified, only numeric values are returned and strings are omitted.}

\item{output}{Should the output be structured as a \code{"list"} or a \code{"data.frame"}?}

\item{classes}{Character vector with the classes to which \code{checkMissingLabels()} should be applied. Valid options are \code{"integer"}, \code{"double"}, and \code{"character"}.}
}
\value{
Returns a list of length \code{vars} or a \code{data.frame}.
}
\description{
Check value labels for (a) value labels with no occurrence in the data (\code{checkEmptyValLabels}) and
(b) values with no value labels (\code{checkMissingValLabels}).
}
\details{
\code{NAs} are excluded from this check. Designated missing codes are reported normally.
}
\section{Functions}{
\itemize{
\item \code{checkEmptyValLabels()}: check for superfluous value labels

\item \code{checkMissingValLabels()}: check for missing value labels

}}
\examples{
# Check a categorical and a metric variable
checkMissingValLabels(pisa, vars = c("g8g9", "age"))
checkEmptyValLabels(pisa, vars = c("g8g9", "age"))

# Check while defining a specific value range
checkMissingValLabels(pisa, vars = c("g8g9", "age", "idschool"),
              valueRange = c(0, 5))
checkEmptyValLabels(pisa, vars = c("g8g9", "age", "idschool"),
              valueRange = c(0, 5))

}
