% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changeSPSSformat.R
\name{changeSPSSformat}
\alias{changeSPSSformat}
\title{Change SPSS format.}
\usage{
changeSPSSformat(GADSdat, varName, format)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{varName}{Character vector of variable names.}

\item{format}{A single string containing the new SPSS format, for example 'A25' or 'F10'.}
}
\value{
Returns the \code{GADSdat} object with changed meta data..
}
\description{
Change the SPSS format of one or multiple variables as part of a \code{GADSdat} object.
}
\details{
Applied to a \code{GADSdat} or \code{all_GADSdat} object, this function is a wrapper
of \code{\link{getChangeMeta}} and \code{\link{applyChangeMeta}}.

SPSS format is supplied following SPSS logic. \code{'A'} represents character variables,
\code{'F'} represents numeric variables. The number following this letter represents the maximum width.
Optionally, another number can be added after a dot, representing the number of decimals
in case of a numeric variable. For instance, \code{'F8.2'} is used for a numeric variable with
a maximum width of 8 with 2 decimal numbers.
}
\examples{
# change SPSS format for a single variable (numeric variable with no decimals)
pisa2 <- changeSPSSformat(pisa, varName = "idstud",
                          format = "F10.0")

# change SPSS format for multiple variables (numeric variable with no decimals)
pisa2 <- changeSPSSformat(pisa, varName = c("idstud", "idschool"),
                          format = "F10.0")

}
