% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten.R
\name{flatten}
\alias{flatten}
\title{Flatten a List or Other Object}
\usage{
flatten(x, level = -1, ...)
}
\arguments{
\item{x}{object of any class, but primarily designed for lists and other "deep" objects}

\item{level}{numeric integer describing the depth at which to flatten the object. If \code{level < 0}, the object will become as flat as possible.}

\item{...}{objects passed to methods}
}
\value{
flatter object
}
\description{
Reduces the depth of a list or other object. Most non-atomic objects (matrix,
data.frame, environments, etc.) are converted to a "list" in the first level
flattening. Atomic vectors, functions, and other special objects return themselves.
}
\details{
\code{flatten} maps itself to each object with the aggregate \code{x}, combining
the results. Each time it is mapped, the level is reduced by 1. When \code{level == 0},
or an atomic vector or other special object is reached, \code{flatten} returns
the object without mapping itself.
}
\examples{
x <- list(a = 1, b = 2:5, c = list(list(1,2,3), 4, 5), 6)
flatten(x)
## returns: [1 2 3 4 5 1 2 3 4 5 6]

flatten(x, level=1)
## returns: [1 2 3 4 5 [1 2 3] 4 5 6]

}
