#-------------------------------------------------------------------------------
# Copyright (c) 2019-2022 University of Newcastle upon Tyne. All rights reserved.
# Copyright (c) 2022-2025 Arjuna Technologies, Newcastle upon Tyne. All rights reserved.
#
# This program and the accompanying materials
# are made available under the terms of the GNU Public License v3.0.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#-------------------------------------------------------------------------------

#
# Set up
#

# context("ds.glmPredict::smk::poisson::setup")

connect.studies.dataset.cnsim(list("LAB_TSC", "LAB_TRIG", "DIS_AMI", "DIS_DIAB", "GENDER"))

test_that("setup", {
  ds_expect_variables(c("D"))
})

#
# Tests
#

# context("ds.glmPredict::smk::poisson::without_newobj")
test_that("simple glmPredict, poisson, without newobj, se.fit=FALSE", {
  glmSLMA.res <- ds.glmSLMA('D$LAB_TSC~D$LAB_TRIG', family="poisson", newobj="poisson.glmslma.obj")
  
  expect_length(glmSLMA.res, 9)
  expect_equal(glmSLMA.res$num.valid.studies, 3)
  expect_length(glmSLMA.res$validity.check, 1)
  expect_equal(glmSLMA.res$validity.check, "<poisson.glmslma.obj> appears valid in all sources")
  
  res <- ds.glmPredict("poisson.glmslma.obj", newdataname = NULL, output.type = "response", se.fit = FALSE, na.action = "na.pass")
  
  expect_length(res, 3)
  expect_equal(class(res), "list")
  
  expect_length(res$sim1, 1)
  expect_length(res$sim1$safe.list, 10)
  expect_equal(class(res$sim1$safe.list), "list")
  expect_equal(res$sim1$safe.list$glm.object, "poisson.glmslma.obj")
  expect_true(is.null(res$sim1$safe.list$newdfname))
  expect_equal(res$sim1$safe.list$output.type, "response")
  expect_true(is.null(res$sim1$safe.list$dispersion))
  expect_equal(res$sim1$safe.list$fit.Ntotal, 1801)
  expect_equal(res$sim1$safe.list$fit.Nvalid, 1801)
  expect_equal(res$sim1$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim1$safe.list$fit.mean, 5.872024, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.sd, 0.3720242, tolerance = ds.test_env$tolerance)
  expect_length(res$sim1$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim1$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim1$safe.list$fit.quantiles[[1]], 5.659318, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[2]], 5.704707, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[3]], 5.778435, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[4]], 5.871512, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[5]], 5.959795, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[6]], 6.044552, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[7]], 6.093175, tolerance = ds.test_env$tolerance)
  
  expect_length(res$sim2, 1)
  expect_length(res$sim2$safe.list, 10)
  expect_equal(class(res$sim2$safe.list), "list")
  expect_equal(res$sim2$safe.list$glm.object, "poisson.glmslma.obj")
  expect_true(is.null(res$sim2$safe.list$newdfname))
  expect_equal(res$sim2$safe.list$output.type, "response")
  expect_true(is.null(res$sim2$safe.list$dispersion))
  expect_equal(res$sim2$safe.list$fit.Ntotal, 2526)
  expect_equal(res$sim2$safe.list$fit.Nvalid, 2526)
  expect_equal(res$sim2$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim2$safe.list$fit.mean, 5.843564, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.sd, 0.3027769, tolerance = ds.test_env$tolerance)
  expect_length(res$sim2$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim2$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim2$safe.list$fit.quantiles[[1]], 5.694361, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[2]], 5.725835, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[3]], 5.782577, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[4]], 5.843101, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[5]], 5.902120, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[6]], 5.959162, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[7]], 5.991181, tolerance = ds.test_env$tolerance)
  
  expect_length(res$sim3, 1)
  expect_length(res$sim3$safe.list, 10)
  expect_equal(class(res$sim3$safe.list), "list")
  expect_equal(res$sim3$safe.list$glm.object, "poisson.glmslma.obj")
  expect_true(is.null(res$sim3$safe.list$newdfname))
  expect_equal(res$sim3$safe.list$output.type, "response")
  expect_true(is.null(res$sim3$safe.list$dispersion))
  expect_equal(res$sim3$safe.list$fit.Ntotal, 3473)
  expect_equal(res$sim3$safe.list$fit.Nvalid, 3473)
  expect_equal(res$sim3$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim3$safe.list$fit.mean, 5.846405, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.sd, 0.3546933, tolerance = ds.test_env$tolerance)
  expect_length(res$sim3$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim3$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim3$safe.list$fit.quantiles[[1]], 5.642464, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[2]], 5.693362, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[3]], 5.763027, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[4]], 5.844277, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[5]], 5.927911, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[6]], 6.005366, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[7]], 6.056664, tolerance = ds.test_env$tolerance)
})

# context("ds.glmPredict::smk::poisson::with_newobj")
test_that("simple glmPredict, poisson, with newobj, se.fit=FALSE", {
  glmSLMA.res <- ds.glmSLMA('D$LAB_TSC~D$LAB_TRIG', family="poisson", newobj="poisson.glmslma.obj")
  
  expect_length(glmSLMA.res, 9)
  expect_equal(glmSLMA.res$num.valid.studies, 3)
  expect_length(glmSLMA.res$validity.check, 1)
  expect_equal(glmSLMA.res$validity.check, "<poisson.glmslma.obj> appears valid in all sources")
  
  res <- ds.glmPredict("poisson.glmslma.obj", newdataname = NULL, output.type = "response", se.fit = FALSE, na.action = "na.pass", newobj="poisson.glm.predict.obj")
  
  expect_length(res, 3)
  expect_equal(class(res), "list")
  
  expect_length(res$sim1, 1)
  expect_length(res$sim1$safe.list, 10)
  expect_equal(class(res$sim1$safe.list), "list")
  expect_equal(res$sim1$safe.list$glm.object, "poisson.glmslma.obj")
  expect_true(is.null(res$sim1$safe.list$newdfname))
  expect_equal(res$sim1$safe.list$output.type, "response")
  expect_true(is.null(res$sim1$safe.list$dispersion))
  expect_equal(res$sim1$safe.list$fit.Ntotal, 1801)
  expect_equal(res$sim1$safe.list$fit.Nvalid, 1801)
  expect_equal(res$sim1$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim1$safe.list$fit.mean, 5.872024, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.sd, 0.3720242, tolerance = ds.test_env$tolerance)
  expect_length(res$sim1$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim1$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim1$safe.list$fit.quantiles[[1]], 5.659318, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[2]], 5.704707, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[3]], 5.778435, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[4]], 5.871512, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[5]], 5.959795, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[6]], 6.044552, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[7]], 6.093175, tolerance = ds.test_env$tolerance)
  
  expect_length(res$sim2, 1)
  expect_length(res$sim2$safe.list, 10)
  expect_equal(class(res$sim2$safe.list), "list")
  expect_equal(res$sim2$safe.list$glm.object, "poisson.glmslma.obj")
  expect_true(is.null(res$sim2$safe.list$newdfname))
  expect_equal(res$sim2$safe.list$output.type, "response")
  expect_true(is.null(res$sim2$safe.list$dispersion))
  expect_equal(res$sim2$safe.list$fit.Ntotal, 2526)
  expect_equal(res$sim2$safe.list$fit.Nvalid, 2526)
  expect_equal(res$sim2$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim2$safe.list$fit.mean, 5.843564, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.sd, 0.3027769, tolerance = ds.test_env$tolerance)
  expect_length(res$sim2$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim2$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim2$safe.list$fit.quantiles[[1]], 5.694361, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[2]], 5.725835, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[3]], 5.782577, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[4]], 5.843101, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[5]], 5.902120, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[6]], 5.959162, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[7]], 5.991181, tolerance = ds.test_env$tolerance)
  
  expect_length(res$sim3, 1)
  expect_length(res$sim3$safe.list, 10)
  expect_equal(class(res$sim3$safe.list), "list")
  expect_equal(res$sim3$safe.list$glm.object, "poisson.glmslma.obj")
  expect_true(is.null(res$sim3$safe.list$newdfname))
  expect_equal(res$sim3$safe.list$output.type, "response")
  expect_true(is.null(res$sim3$safe.list$dispersion))
  expect_equal(res$sim3$safe.list$fit.Ntotal, 3473)
  expect_equal(res$sim3$safe.list$fit.Nvalid, 3473)
  expect_equal(res$sim3$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim3$safe.list$fit.mean, 5.846405, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.sd, 0.3546933, tolerance = ds.test_env$tolerance)
  expect_length(res$sim3$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim3$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim3$safe.list$fit.quantiles[[1]], 5.642464, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[2]], 5.693362, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[3]], 5.763027, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[4]], 5.844277, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[5]], 5.927911, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[6]], 6.005366, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[7]], 6.056664, tolerance = ds.test_env$tolerance)
})

# context("ds.glmPredict::smk::poisson::sefit_true")
test_that("simple glmPredict, poisson, with newobj, se.fit=TRUE", {
  glmSLMA.res <- ds.glmSLMA('D$LAB_TSC~D$LAB_TRIG', family="poisson", newobj="poisson.glmslma.obj")
  
  expect_length(glmSLMA.res, 9)
  expect_equal(glmSLMA.res$num.valid.studies, 3)
  expect_length(glmSLMA.res$validity.check, 1)
  expect_equal(glmSLMA.res$validity.check, "<poisson.glmslma.obj> appears valid in all sources")
  
  res <- ds.glmPredict("poisson.glmslma.obj", newdataname = NULL, output.type = "response", se.fit = TRUE, na.action = "na.pass", newobj="poisson.glm.predict.sefit.obj")
  
  expect_length(res, 3)
  expect_equal(class(res), "list")
  
  expect_length(res$sim1, 1)
  expect_length(res$sim1$safe.list, 17)
  expect_equal(class(res$sim1$safe.list), "list")
  expect_equal(res$sim1$safe.list$glm.object, "poisson.glmslma.obj")
  expect_true(is.null(res$sim1$safe.list$newdfname))
  expect_equal(res$sim1$safe.list$output.type, "response")
  expect_true(is.null(res$sim1$safe.list$dispersion))
  expect_equal(res$sim1$safe.list$fit.Ntotal, 1801)
  expect_equal(res$sim1$safe.list$fit.Nvalid, 1801)
  expect_equal(res$sim1$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim1$safe.list$fit.mean, 5.872024, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.sd, 0.138402, tolerance = ds.test_env$tolerance)
  expect_length(res$sim1$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim1$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim1$safe.list$fit.quantiles[[1]], 5.659318, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[2]], 5.704707, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[3]], 5.778435, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[4]], 5.871512, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[5]], 5.959795, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[6]], 6.044552, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$fit.quantiles[[7]], 6.093175, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.Ntotal, 1801)
  expect_equal(res$sim1$safe.list$se.fit.Nvalid, 1801)
  expect_equal(res$sim1$safe.list$se.fit.Nmiss, 0)
  expect_equal(res$sim1$safe.list$se.fit.mean, 0.07678458, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.sd, 0.02570748, tolerance = ds.test_env$tolerance)
  expect_length(res$sim1$safe.list$se.fit.quantiles, 7)
  expect_equal(class(res$sim1$safe.list$se.fit.quantiles), "numeric")
  expect_equal(res$sim1$safe.list$se.fit.quantiles[[1]], 0.05723954, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.quantiles[[2]], 0.05756343, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.quantiles[[3]], 0.05993096, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.quantiles[[4]], 0.06818918, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.quantiles[[5]], 0.08504048, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.quantiles[[6]], 0.10601561, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$se.fit.quantiles[[7]], 0.12380425, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$residual.scale, 1, tolerance = ds.test_env$tolerance)
  
  expect_length(res$sim2, 1)
  expect_length(res$sim2$safe.list, 17)
  expect_equal(class(res$sim2$safe.list), "list")
  expect_equal(res$sim2$safe.list$glm.object, "poisson.glmslma.obj")
  expect_true(is.null(res$sim2$safe.list$newdfname))
  expect_equal(res$sim2$safe.list$output.type, "response")
  expect_true(is.null(res$sim2$safe.list$dispersion))
  expect_equal(res$sim2$safe.list$fit.Ntotal, 2526)
  expect_equal(res$sim2$safe.list$fit.Nvalid, 2526)
  expect_equal(res$sim2$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim2$safe.list$fit.mean, 5.843564, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.sd, 0.09167387, tolerance = ds.test_env$tolerance)
  expect_length(res$sim2$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim2$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim2$safe.list$fit.quantiles[[1]], 5.694361, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[2]], 5.725835, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[3]], 5.782577, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[4]], 5.843101, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[5]], 5.902120, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[6]], 5.959162, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$fit.quantiles[[7]], 5.991181, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.Ntotal, 2526)
  expect_equal(res$sim2$safe.list$se.fit.Nvalid, 2526)
  expect_equal(res$sim2$safe.list$se.fit.Nmiss, 0)
  expect_equal(res$sim2$safe.list$se.fit.mean, 0.0648018, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.sd, 0.0209345, tolerance = ds.test_env$tolerance)
  expect_length(res$sim2$safe.list$se.fit.quantiles, 7)
  expect_equal(class(res$sim2$safe.list$se.fit.quantiles), "numeric")
  expect_equal(res$sim2$safe.list$se.fit.quantiles[[1]], 0.04816489, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.quantiles[[2]], 0.04838696, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.quantiles[[3]], 0.05008767, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.quantiles[[4]], 0.05740926, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.quantiles[[5]], 0.07294716, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.quantiles[[6]], 0.09144008, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim2$safe.list$se.fit.quantiles[[7]], 0.10463771, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$residual.scale, 1, tolerance = ds.test_env$tolerance)
  
  expect_length(res$sim3, 1)
  expect_length(res$sim3$safe.list, 17)
  expect_equal(class(res$sim3$safe.list), "list")
  expect_equal(res$sim3$safe.list$glm.object, "poisson.glmslma.obj")
  expect_true(is.null(res$sim3$safe.list$newdfname))
  expect_equal(res$sim3$safe.list$output.type, "response")
  expect_true(is.null(res$sim3$safe.list$dispersion))
  expect_equal(res$sim3$safe.list$fit.Ntotal, 3473)
  expect_equal(res$sim3$safe.list$fit.Nvalid, 3473)
  expect_equal(res$sim3$safe.list$fit.Nmiss, 0)
  expect_equal(res$sim3$safe.list$fit.mean, 5.846405, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.sd, 0.1258073, tolerance = ds.test_env$tolerance)
  expect_length(res$sim3$safe.list$fit.quantiles, 7)
  expect_equal(class(res$sim3$safe.list$fit.quantiles), "numeric")
  expect_equal(res$sim3$safe.list$fit.quantiles[[1]], 5.642464, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[2]], 5.693362, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[3]], 5.763027, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[4]], 5.844277, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[5]], 5.927911, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[6]], 6.005366, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$fit.quantiles[[7]], 6.056664, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.Ntotal, 3473)
  expect_equal(res$sim3$safe.list$se.fit.Nvalid, 3473)
  expect_equal(res$sim3$safe.list$se.fit.Nmiss, 0)
  expect_equal(res$sim3$safe.list$se.fit.mean, 0.05532801, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.sd, 0.01769327, tolerance = ds.test_env$tolerance)
  expect_length(res$sim3$safe.list$se.fit.quantiles, 7)
  expect_equal(class(res$sim3$safe.list$se.fit.quantiles), "numeric")
  expect_equal(res$sim3$safe.list$se.fit.quantiles[[1]], 0.04113095, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.quantiles[[2]], 0.04141931, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.quantiles[[3]], 0.04299643, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.quantiles[[4]], 0.04912607, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.quantiles[[5]], 0.06099111, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.quantiles[[6]], 0.07939059, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim3$safe.list$se.fit.quantiles[[7]], 0.08947167, tolerance = ds.test_env$tolerance)
  expect_equal(res$sim1$safe.list$residual.scale, 1, tolerance = ds.test_env$tolerance)
})

#
# Shutdown
#

# context("ds.glmPredict::smk::poisson::shutdown")

test_that("shutdown", {
  ds_expect_variables(c("D", "poisson.glm.predict.obj", "poisson.glm.predict.sefit.obj", "poisson.glmslma.obj", "predict_glm" ))
})

disconnect.studies.dataset.cnsim()

#
# Done
#

# context("ds.glmPredict::smk::poisson::done")
