#' Open Graphical User Interface (GUI)
#'
#' `open_gui` uses shiny to open an interactive interface for code-free DRI
#' analysis
#'
#' @returns NA
#' @export
#'
#' @import shiny
#'
#' @examples
#' \dontrun{
#' open_gui()
#' }
open_gui <- function() {
  dir <- system.file("shiny", package = "deliberr")
  if (dir == "") {
    stop("Could not find home directory. Try re-installing `deliberr`.", call. = FALSE)
  }

  shiny::runApp(dir, launch.browser = TRUE, display.mode = "normal")
}
