% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcmstan-package.R
\docType{package}
\name{dcmstan-package}
\alias{dcmstan}
\alias{dcmstan-package}
\title{dcmstan: Generate 'Stan' Code for Diagnostic Classification Models}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Diagnostic classification models are psychometric models used to categorically estimate respondents mastery, or proficiency, on a set of predefined skills (Bradshaw, 2016, \doi{10.1002/9781118956588.ch13}). Diagnostic models can be estimated with 'Stan'; however, the necessary scripts can be long and complicated. This package automates the creation of 'Stan' scripts for diagnostic classification models. Specify different types of diagnostic models, define prior distributions, and automatically generate the necessary 'Stan' code for estimating the model.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://dcmstan.r-dcm.org}
  \item \url{https://github.com/r-dcm/dcmstan}
  \item Report bugs at \url{https://github.com/r-dcm/dcmstan/issues}
}

}
\author{
\strong{Maintainer}: W. Jake Thompson \email{wjakethompson@gmail.com} (\href{https://orcid.org/0000-0001-7339-0300}{ORCID})

Authors:
\itemize{
  \item Jeffrey Hoover \email{jeffrey.c.hoover@gmail.com} (\href{https://orcid.org/0000-0002-0276-0308}{ORCID})
  \item Auburn Jimenez \email{auburn.jimenez34@gmail.com} (\href{https://orcid.org/0000-0002-7072-2960}{ORCID})
}

Other contributors:
\itemize{
  \item University of Kansas [copyright holder]
  \item Institute of Education Sciences [funder]
}

}
\keyword{internal}
