% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cempre.R
\name{load_cempre}
\alias{load_cempre}
\title{CEMPRE - Central Register of Companies}
\usage{
load_cempre(
  dataset = "cempre",
  raw_data = FALSE,
  geo_level,
  time_period,
  language = "eng",
  sectors = FALSE
)
}
\arguments{
\item{dataset}{A dataset name ("cempre").}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{geo_level}{A \code{string} that defines the geographic level of the data. Can be one of "country", "state" or "municipality".}

\item{time_period}{A \code{numeric} indicating for which years the data will be loaded, in the format YYYY. Can be any vector of numbers, such as 2010:2012.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Portuguese ("pt") and English ("eng") are supported.}

\item{sectors}{A \code{boolean} that defines if the data will be return separated by sectors (\code{TRUE}) or not (\code{FALSE}).}
}
\value{
A \code{tibble}.
}
\description{
Loads information on companies and other organizations and their respective formally constituted local units, registered with the CNPJ - National Register of Legal Entities.
}
\examples{
\dontrun{
# Download raw data (raw_data = TRUE) at the country level
# from 2008 to 2010 (time_period = 2008:2010).
data <- load_cempre(
  raw_data = TRUE,
  geo_level = "country",
  time_period = 2008:2010
)

# Download treted data (raw_data = FALSE) by state (geo_level = "state")
# from 2008 to 2010 (time_period = 2008:2010) in portuguese (language = "pt").
# In this example, data is split by sector (sectors = TRUE)
data <- load_cempre(
  raw_data = FALSE,
  geo_level = "state",
  time_period = 2008:2010,
  language = "pt",
  sectors = TRUE
)
}

}
