% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_bayes_estimate.R
\name{full_crossover}
\alias{full_crossover}
\title{Perform a Full Crossover Step Using Differential Evolution}
\usage{
full_crossover(
  prms_across_chains,
  pis_across_chains,
  log_likes_across_chains,
  gamma = NULL,
  b = 0.001,
  ...
)
}
\arguments{
\item{prms_across_chains}{a numeric matrix of dimension \verb{p × n}, where \code{p}
is the number of parameters and \code{n} is the number of chains. Each column
contains the current parameter vector of a chain.}

\item{pis_across_chains}{a numeric vector of length \code{n}, containing the
current log-posterior values for each chain.}

\item{log_likes_across_chains}{a numeric vector of length \code{n}, containing the
current log-likelihood values for each chain.}

\item{gamma}{a single numeric tuning parameter, that scales the difference
between parameters. If \code{NULL}, defaults to \code{2.38 / sqrt(2 * n_prms)}}

\item{b}{a small numeric value used to perturb the proposal parameters to
avoid degeneracy.}

\item{...}{additional arguments passed to \code{\link[=call_log_posterior_m]{call_log_posterior_m()}}.}
}
\value{
A list with the following components:
\itemize{
\item \code{new_prms_across_chains}: The updated parameter matrix of shape \verb{p × n}.
\item \code{new_pis_across_chains}: The updated vector of log-posterior values.
\item \code{new_log_likes_across_chains}: The updated vector of log-likelihood values.
}
}
\description{
This function updates each chain's parameters by proposing new values using a
differential evolution strategy. For each chain \code{k}, two other chains
\code{m} and \code{n} are randomly selected, and a proposal is generated via:
\code{prms_k + gamma * (prms_m - prms_n) + noise},
where \code{gamma = 2.38 / sqrt(2 * n_prms)}
and \code{noise} is uniform perturbation controlled by \code{b}. The proposal is
accepted with Metropolis probability via \code{\link[=call_log_posterior_m]{call_log_posterior_m()}},
and accepted proposals replace the current values.
}
\keyword{internal}
