% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{LogisticIndepBeta-class}
\alias{LogisticIndepBeta-class}
\alias{.LogisticIndepBeta}
\alias{LogisticIndepBeta}
\alias{.DefaultLogisticIndepBeta}
\title{\code{LogisticIndepBeta}}
\usage{
LogisticIndepBeta(binDLE, DLEdose, DLEweights, data)

.DefaultLogisticIndepBeta()
}
\arguments{
\item{binDLE}{(\code{numeric})\cr the number of subjects observed with a DLE, the
pseudo DLE responses, depending on dose levels \code{DLEdose}.
Elements of \code{binDLE} must correspond to the elements of \code{DLEdose} and
\code{DLEweights}.}

\item{DLEdose}{(\code{numeric})\cr dose levels for the pseudo DLE responses.
Elements of \code{DLEdose} must correspond to the elements of \code{binDLE} and
\code{DLEweights}.}

\item{DLEweights}{(\code{numeric})\cr the total number of subjects treated at each
of the dose levels \code{DLEdose}, pseudo weights.
Elements of \code{DLEweights} must correspond to the elements of \code{binDLE} and
\code{DLEdose}.}

\item{data}{(\code{Data})\cr the input data to update estimates of the model
parameters.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{LogisticIndepBeta}} is the class for the two-parameters logistic regression
dose-limiting events (DLE) model with prior expressed in form of pseudo data.
This model describes the relationship between the binary DLE responses
and the dose levels. More specifically, it represents the relationship of the
probabilities of the occurrence of a DLE for corresponding dose levels in log
scale. This model is specified as
\deqn{p(x) = exp(phi1 + phi2 * log(x)) / (1 + exp(phi1 + phi2 * log(x)))}
where \eqn{p(x)} is the probability of the occurrence of a DLE at dose \eqn{x}.
The two parameters of this model are the intercept \eqn{phi1} and the slope
\eqn{phi2}. The \code{LogisticIndepBeta} inherits all slots from \code{\link{ModelTox}} class.

In the context of pseudo data, the following three arguments are used,
\code{binDLE}, \code{DLEdose} and \code{DLEweights}. The \code{DLEdose} represents fixed dose
levels at which the pseudo DLE responses \code{binDLE} are observed. \code{DLEweights}
represents total number of subjects treated per each dose level in \code{DLEdose}.
The \code{binDLE} represents the number of subjects observed with DLE per each
dose level in \code{DLEdose}. Hence, all these three vectors must be of the same
length and the order of the elements in any of the vectors \code{binDLE},
\code{DLEdose} and \code{DLEweights} must be kept, so that an element of a given vector
corresponds to the elements of the remaining two vectors (see the example for
more insight).
Finally, since at least two DLE pseudo responses are needed to
obtain prior modal estimates (same as the maximum likelihood estimates) for
the model parameters, the \code{binDLE}, \code{DLEdose} and \code{DLEweights} must all be
vectors of at least length 2.
}
\details{
The pseudo data can be interpreted as if we obtain some observations
before the trial starts. It can be used to express our prior, i.e. the
initial beliefs for the model parameters. The pseudo data is expressed in
the following way. First, fix at least two dose levels, then ask for experts'
opinion on how many subjects are to be treated at each of these dose levels
and on the number of subjects observed with a DLE. At each dose level, the
number of subjects observed with a DLE, divided by the total number of
subjects treated, is the probability of the occurrence of a DLE at that
particular dose level. The probabilities of the occurrence of a DLE based
on this pseudo data are independent and they follow Beta distributions.
Therefore, the joint prior probability density function of all these
probabilities can be obtained. Hence, by a change of variable, the joint
prior probability density function of the two parameters in this model can
also be obtained. In addition, a conjugate joint prior density function of
the two parameters in the model is used. For details about the form of all
these joint prior and posterior probability density functions, please refer
to \insertCite{WhiteheadWilliamson1998;textual}{crmPack}.
}
\section{Slots}{

\describe{
\item{\code{binDLE}}{(\code{numeric})\cr a vector of total numbers of DLE responses.
It must be at least of length 2 and the order of its elements must
correspond to values specified in \code{DLEdose} and \code{DLEweights}.}

\item{\code{DLEdose}}{(\code{numeric})\cr a vector of the dose levels corresponding to
It must be at least of length 2 and the order of its elements must
correspond to values specified in \code{binDLE} and \code{DLEweights}.}

\item{\code{DLEweights}}{(\code{integer})\cr total number of subjects treated at each of
the pseudo dose level \code{DLEdose}.
It must be at least of length 2 and the order of its elements must
correspond to values specified in \code{binDLE} and \code{DLEdose}.}

\item{\code{phi1}}{(\code{number})\cr  the intercept of the model. This slot is used in
output to display the resulting prior or posterior modal estimate of the
intercept obtained based on the pseudo data and (if any) observed data/responses.}

\item{\code{phi2}}{(\code{number})\cr  the slope of the model. This slot is used in output
to display the resulting prior or posterior modal estimate of the slope
obtained based on the pseudo data and (if any) the observed data/responses.}

\item{\code{Pcov}}{(\code{matrix})\cr refers to the 2x2 covariance matrix of the intercept
(\eqn{phi1}) and the slope parameters (\eqn{phi2}) of the model.
This is used in output to display the resulting prior and posterior
covariance matrix of \eqn{phi1} and \eqn{phi2} obtained, based on the
pseudo data and (if any) the observed data and responses. This slot is
needed for internal purposes.}
}}

\note{
Typically, end users will not use the \code{.DefaultLogisticIndepBeta()} function.
}
\examples{
# Obtain prior modal estimates given the pseudo data.
# First we used an empty data set such that only the dose levels under
# investigations are given. In total, 12 dose levels are under investigation
# ranging from 25 to 300 mg with increments of 25 (i.e 25, 50, 75, ..., 300).
emptydata <- Data(doseGrid = seq(25, 300, 25))

# Fix two dose levels 25 and 300 mg (DLEdose).
# Total number of subjects treated in each of these levels is 3, (DLEweights).
# The number of subjects observed with a DLE is 1.05 at dose 25 mg and 1.8 at dose 300 mg (binDLE).
my_model1 <- LogisticIndepBeta(
  binDLE = c(1.05, 1.8),
  DLEdose = c(25, 300),
  DLEweights = c(3, 3),
  data = emptydata
)

# Use observed DLE responses to obtain posterior modal estimates.
my_data <- Data(
  x = c(25, 50, 50, 75, 100, 100, 225, 300),
  y = c(0, 0, 0, 0, 1, 1, 1, 1),
  doseGrid = emptydata@doseGrid
)

my_model2 <- LogisticIndepBeta(
  binDLE = c(1.05, 1.8),
  DLEdose = c(25, 300),
  DLEweights = c(3, 3),
  data = my_data
)
}
\references{
\insertAllCited{}
}
