% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertId2.R
\name{convert.bm}
\alias{convert.bm}
\title{Retrieve Additional Annotations from Biomart}
\usage{
convert.bm(
  dat,
  id = "ID",
  biom.data.set = c("human", "mouse"),
  biom.mart = c("ensembl", "mouse", "snp", "funcgen", "plants"),
  host = "https://www.ensembl.org",
  biom.filter = "ensembl_gene_id",
  biom.attributes = c("ensembl_gene_id", "hgnc_symbol", "description"),
  biom.cache = rappdirs::user_cache_dir("biomaRt"),
  use.cache = TRUE,
  sym.col = "hgnc_symbol",
  rm.dups = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{dat}{\code{matrix} or \code{data.frame}. Matrix or data frame with the ids to be converted in a column or as row names.}

\item{id}{\code{character}. Name of the column with the ids to be converted, special name "rownames" will use the row names.}

\item{biom.data.set}{\code{character} of length one. Biomart data set to use.}

\item{biom.mart}{\code{character} vector. Biomart to use (uses the first element of the vector), defaults to "ensembl".}

\item{host}{\code{character} of length one. Host URL.}

\item{biom.filter}{\code{character} of length one. Name of biomart filter, i.e., type of query ids, defaults to "ensembl_gene_id".}

\item{biom.attributes}{\code{character} vector. Biomart attributes, i.e., type of desired result(s); make sure query id type is included!}

\item{biom.cache}{\code{character}. Path name giving the location of the cache \command{getBM()} uses if \code{use.cache=TRUE}. Defaults to the value in the \emph{BIOMART_CACHE} environment variable.}

\item{use.cache}{(\code{logical}). Should \command{getBM()} use the cache? Defaults to \code{TRUE} as in the \command{getBM()} function and is passed on to that.}

\item{sym.col}{\code{character}. Name of the column in the query result with gene symbols.}

\item{rm.dups}{\code{logical}. Should duplicated input IDs (\option{biom.filter}) be removed from the result?}

\item{verbose}{(\code{logical}). Should verbose output be written to the console? Defaults to \code{FALSE}.}
}
\value{
A data frame with the retrieved information.
}
\description{
\command{convert.bm()} is a wrapper for \command{get.bm()} which in turn makes use of \command{getBM()} from the \emph{biomaRt} package.
It takes a matrix or data frame with the IDs to be converted in one column or as row names as input and returns a data frame with additional
annotations after cleaning the fetched annotations and merging them with the input data frame.
}
\details{
Wrapped around `get.bm`.
}
\examples{
\dontrun{
dat <- data.frame(ID=c("ENSG00000111199", "ENSG00000134121", "ENSG00000176102", "ENSG00000171611"))
bm <- convert.bm(dat)
bm
}
}
\seealso{
\command{\link[biomaRt]{getBM}}
}
\author{
Vidal Fey
}
\keyword{utilities}
