% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_multidyads.R
\name{preprocess_dyads}
\alias{preprocess_dyads}
\title{Preprocess multiple dyad conversations}
\usage{
preprocess_dyads(conversations)
}
\arguments{
\item{conversations}{A data frame with columns 'dyad_id', 'speaker', and 'text'}
}
\value{
A data frame with an additional 'processed_text' column, removing any rows with empty processed text
}
\description{
This function preprocesses conversations from multiple dyads by applying text cleaning to each utterance.
}
\examples{
convs <- data.frame(
  dyad_id = c(1, 1, 2, 2),
  speaker = c("A", "B", "C", "D"),
  text = c("Hello!", "Hi there!", "How are you?", "I'm fine, thanks!")
)
preprocess_dyads(convs)
}
