% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_sequence_utilities.R
\name{plot_sim_seq}
\alias{plot_sim_seq}
\title{Plot Similarity Sequence}
\usage{
plot_sim_seq(similarity, title)
}
\arguments{
\item{similarity}{A list containing the sequence of similarities and the average similarity}

\item{title}{A character string for the plot title}
}
\value{
A ggplot object
}
\description{
Plot similarity sequence for a single dyad
}
\details{
This function creates a line plot of the similarity sequence for a single dyad.
}
\examples{
sim_list <- list(
  sequence = c(0.5, 0.6, 0.7, 0.6, 0.8),
  average = 0.64
)

# Plot the similarity sequence
plot <- plot_sim_seq(sim_list, "Dyad Similarity Sequence")
print(plot)
}
