% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_multidyads_utilities.R
\name{plot_sim_cor_heatmap}
\alias{plot_sim_cor_heatmap}
\title{Plot heatmap of similarity measure correlations}
\usage{
plot_sim_cor_heatmap(cor_matrix, title)
}
\arguments{
\item{cor_matrix}{A correlation matrix output from calc_sim_cor()}

\item{title}{A string specifying the plot title}
}
\value{
A ggplot object
}
\description{
This function creates a ggplot object showing a heatmap of correlations between similarity measures.
}
\examples{
topic_similarities <- list("1" = c(0.5, 0.6, 0.7), "2" = c(0.4, 0.5, 0.6))
lexical_similarities <- list("1" = c(0.6, 0.7, 0.8), "2" = c(0.5, 0.6, 0.7))
comparison_df <- compare_sim_meas(
  list(topic_similarities, lexical_similarities),
  c("Topic", "Lexical")
)
cor_matrix <- calc_sim_cor(comparison_df)
plot_sim_cor_heatmap(cor_matrix, "Correlation of Similarity Measures")
print(plot)
}
