% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_sequence.R
\name{calc_sim_seq}
\alias{calc_sim_seq}
\title{Calculate similarity sequence}
\usage{
calc_sim_seq(conversation, window_size, similarity_func)
}
\arguments{
\item{conversation}{A dataframe containing the conversation, with a column named 'processed_text'.}

\item{window_size}{An integer specifying the size of each window.}

\item{similarity_func}{A function that calculates similarity between two text strings.}
}
\value{
A list containing two elements:
  \item{sequence}{A numeric vector of similarity scores between consecutive windows}
  \item{average}{The mean of the similarity scores}
}
\description{
This function calculates a sequence of similarities between consecutive windows in a conversation.
}
\examples{
conversation <- data.frame(processed_text = c("hello", "world", "how", "are", "you"))
result <- calc_sim_seq(conversation, 2, function(x, y) sum(x == y) / max(length(x), length(y)))
}
