% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_binary.R
\name{forest_bin}
\alias{forest_bin}
\title{Contour-Enhanced Binary Outcome Forest Plot}
\usage{
forest_bin(
  dat,
  measure = "OR",
  method = "REML",
  xlab = "",
  title = NULL,
  model = "Random-effects",
  estimator = "REML",
  nc_col = "n_c",
  ne_col = "n_t",
  event_c_col = "events_c",
  event_t_col = "events_t",
  diamond.col = "red",
  study.col = "blue",
  CI.col = "blue",
  Pred.Inter.col = "black",
  square.size = 10,
  contour_fill = c("gray95", "gray80", "gray60", "gray40"),
  text_size = 3.5,
  xlim = c(-1.7, 3.5),
  pred = TRUE,
  xpos = list(EventsT = -0.9, EventsC = -0.3, Effect = 2.6, Weight = 3.1),
  study_x = -1.8,
  hetero_x = -1.7,
  tlim = c(0, 2.3),
  truncate_PI = FALSE,
  contour_left_min = c(0, 0.5, 0.67, 0.83),
  contour_left_max = c(0.5, 0.67, 0.83, 1),
  contour_right_min = c(1, 1.2, 1.5, 2),
  contour_right_max = c(1.2, 1.5, 2, 2.5)
)
}
\arguments{
\item{dat}{Data frame containing study-level binary outcome data.}

\item{measure}{Character. Effect measure ("OR" for odds ratio, "RR" for risk ratio, etc.).}

\item{method}{Character. Method for meta-analysis heterogeneity estimation (default "REML").}

\item{xlab}{Character. Label for the x-axis.}

\item{title}{Character. Plot title. If NULL, a default title is generated.}

\item{model}{Character. Meta-analysis model ("Random-effects" or "Fixed-effects").}

\item{estimator}{Character. Estimator used in the meta-analysis (default "REML").}

\item{nc_col}{Character. Column name for control group sample sizes.}

\item{ne_col}{Character. Column name for treatment group sample sizes.}

\item{event_c_col}{Character. Column name for number of events in control group.}

\item{event_t_col}{Character. Column name for number of events in treatment group.}

\item{diamond.col}{Color of the pooled effect polygon.}

\item{study.col}{Color of the study-level effect points.}

\item{CI.col}{Color of the study-level confidence interval lines.}

\item{Pred.Inter.col}{Color of the prediction interval line.}

\item{square.size}{Numeric. Maximum size of study-level effect squares.}

\item{contour_fill}{Vector of colors for contour shading levels.}

\item{text_size}{Numeric. Base size of plot text.}

\item{xlim}{Numeric vector of length 2. Limits of the x-axis.}

\item{pred}{Logical. Whether to show the prediction interval.}

\item{xpos}{List of numeric positions for text labels (EventsT, EventsC, Effect, Weight).}

\item{study_x}{Numeric. X-position for study names.}

\item{hetero_x}{Numeric. X-position for heterogeneity text.}

\item{tlim}{Numeric vector of length 2. Limits for truncating study confidence intervals.}

\item{truncate_PI}{Logical. Whether to truncate the prediction interval to \code{tlim}.}

\item{contour_left_min}{Numeric vector. Minimum x-values for left-side contour shading.}

\item{contour_left_max}{Numeric vector. Maximum x-values for left-side contour shading.}

\item{contour_right_min}{Numeric vector. Minimum x-values for right-side contour shading.}

\item{contour_right_max}{Numeric vector. Maximum x-values for right-side contour shading.}
}
\value{
A \code{ggplot2} object of the forest plot.
}
\description{
Generates a contour-enhanced forest plot for binary outcome data (e.g., odds ratios, risk ratios),
with study-level effects, confidence intervals, pooled effect, prediction interval, and heterogeneity statistics.
}
\examples{
forest_bin(
  dat = bcg(),
  measure = "OR",
  xlab = "Odds Ratio",
  title = "BCG Vaccine Meta-analysis",
  tlim = c(0, 2.3),
  contour_left_min = c(0,0.3,0.5,0.7),
  contour_left_max = c(0.3,0.5,0.7,1),
  contour_right_min = c(1,1.2,1.5,1.8),
  contour_right_max = c(1.2,1.5,1.8,2.5)
)
}
