% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{FineGray_Model}
\alias{FineGray_Model}
\title{Fine-Gray Model for Competing Risks Data}
\usage{
FineGray_Model(CovarNames = NULL, Failcode = 1, RiskNames = NULL)
}
\arguments{
\item{CovarNames}{A character vector of names for the covariates. If \code{NULL}, default names will be generated.}

\item{Failcode}{An integer specifying the event of interest (default is \code{1}).}

\item{RiskNames}{A character vector specifying the names of the competing risks. If \code{NULL}, default names ("Risk1" and "Risk2") will be used.}
}
\value{
A list containing:
\item{Results}{A summary of the Fine-Gray model fit.}
\item{Plot}{A ggplot object showing the cumulative incidence functions (CIFs) for the competing risks.}
\item{CIF_Results}{A data frame containing the CIFs for the competing risks, along with their corresponding time points.}
}
\description{
This function fits a Fine-Gray model for competing risks data using the \code{cmprsk} package.
It estimates the subdistribution hazard model parameters, computes cumulative incidence functions (CIFs),
and provides a summary of the results along with a plot of the CIFs.
}
\details{
This function retrieves the data initialized in the Cmpp model using the \code{GetData} function.
It uses the \code{crr} function from the \code{cmprsk} package to fit the Fine-Gray model for competing risks.
The function also computes cumulative incidence functions (CIFs) using the \code{cuminc} function and
generates a plot of the CIFs for the competing risks.
}
\examples{
library(cmpp)
data("fertility_data")
Nam <- names(fertility_data)
fertility_data$Education
datt <- make_Dummy(fertility_data, features = c("Education"))
datt <- datt$New_Data 
datt['Primary_Secondary'] <- datt$`Education:2`
datt['Higher_Education'] <- datt$`Education:3`
datt$`Education:2` <- datt$`Education:3` <- NULL
datt2 <- make_Dummy(datt, features = 'Event')$New_Data
d1 <- datt2$`Event:2`
d2 <- datt2$`Event:3`
feat <- datt2[c('age', 'Primary_Secondary', 'Higher_Education')] |> 
   data.matrix()
timee <- datt2[['time']]
Initialize(feat, timee, d1, d2, 1e-10)
result <- FineGray_Model(
  CovarNames = c("Covar1", "Covar2", "Covar3"),
  Failcode = 1,
  RiskNames = c("Event1", "Event2")
)
print(result$Results)  # Summary of the Fine-Gray model
#print(result$Plot)     # Plot of the CIFs
print(result$CIF_Results)  # CIF data

}
