\name{tisdale_qt_score}
\alias{tisdale_qt_score}
\title{
Tisdale Risk Score for QT Prolongation
}
\description{
Calculates the Tisdale Score to predict the risk of QT prolongation (QTc > 500 ms or an increase of >= 60 ms) in hospitalized patients. The score stratifies patients into Low, Moderate, and High risk categories based on clinical risk factors.
}
\usage{
tisdale_qt_score(age, sex, loop_diuretic, serum_potassium, serum_q_t_c, acute_mi,
                 sepsis, heart_failure, one_qtc_drug, two_or_more_qtc_drugs)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 68 years adds 1 point).
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Female adds 1 point).
}
  \item{loop_diuretic}{
Numeric (0 or 1). Use of a loop diuretic. (1 = Yes, +1 point).
}
  \item{serum_potassium}{
Numeric. Serum potassium level in mEq/L. (<= 3.5 mEq/L adds 2 points).
}
  \item{serum_q_t_c}{
Numeric. Baseline QTc interval on admission in ms. (>= 450 ms adds 2 points).
}
  \item{acute_mi}{
Numeric (0 or 1). Diagnosis of acute myocardial infarction. (1 = Yes, +2 points).
}
  \item{sepsis}{
Numeric (0 or 1). Diagnosis of sepsis. (1 = Yes, +3 points).
}
  \item{heart_failure}{
Numeric (0 or 1). Diagnosis of heart failure. (1 = Yes, +3 points).
}
  \item{one_qtc_drug}{
Numeric (0 or 1). Administration of exactly one QTc-prolonging drug. (1 = Yes, +3 points).
}
  \item{two_or_more_qtc_drugs}{
Numeric (0 or 1). Administration of two or more QTc-prolonging drugs. (1 = Yes, +3 points). Note: Maximum points for drugs is 3, whether 1 or >=2 drugs are used. The calculator logic checks for >=2 first or applies the same weight.
}
}
\value{
A list containing:
\item{Tisdale_Score}{The calculated total score (Range 0-21).}
\item{Risk_Level}{Risk stratification (Low <= 6, Moderate 7-10, High >= 11).}
}
\references{
Tisdale JE, Jaynes HA, Kingery JR, et al. Development and validation of a risk score to predict QT interval prolongation in hospitalized patients. Circ Cardiovasc Qual Outcomes. 2013;6(4):479-487. doi:10.1161/CIRCOUTCOMES.113.000152
}
\examples{

# Example 1: High Risk
# Age 70 (1), Female (1), Loop Diuretic (1), K 3.2 (2), QTc 460 (2), HF (3), 1 QT drug (3)
# Score = 13
tisdale_qt_score(70, "female", 1, 3.2, 460, 0, 0, 1, 1, 0)

# Example 2: Low Risk
# Age 50 (0), Male (0), No meds/conditions
# Score = 0
tisdale_qt_score(50, "male", 0, 4.0, 420, 0, 0, 0, 0, 0)
}
