\name{t_macs_decision_aid}
\alias{t_macs_decision_aid}
\title{
Troponin-only Manchester Acute Coronary Syndromes (T-MACS) Decision Aid
}
\description{
Calculates the probability of Acute Coronary Syndrome (ACS) using the T-MACS decision aid. This tool incorporates high-sensitivity cardiac troponin T (hs-cTnT), Heart-type Fatty Acid Binding Protein (H-FABP), ECG findings, and clinical symptoms to risk-stratify patients presenting with chest pain. Note: While the original MACS rule included H-FABP, the T-MACS variation typically relies on hs-cTnT alone or in combination; this function implements the full multivariable model as described in the primary derivation study which included H-FABP.
}
\usage{
t_macs_decision_aid(hs_ctn_t_ng_l, heart_type_fatty_acid_binding_protein_ng_ml,
                    ecg_ischemia, sweating, pain_radiates_to_right_arm_shoulder,
                    pain_worsens_with_movement_palpation, vomiting)
}
\arguments{
  \item{hs_ctn_t_ng_l}{
Numeric. High-sensitivity cardiac troponin T level in ng/L.
}
  \item{heart_type_fatty_acid_binding_protein_ng_ml}{
Numeric. Heart-type Fatty Acid Binding Protein (H-FABP) level in ng/mL.
}
  \item{ecg_ischemia}{
Numeric (0 or 1). Evidence of ischemia on ECG (ST depression, T-wave inversion). (1 = Yes).
}
  \item{sweating}{
Numeric (0 or 1). Observed sweating. (1 = Yes).
}
  \item{pain_radiates_to_right_arm_shoulder}{
Numeric (0 or 1). Pain radiates to the right arm or shoulder. (1 = Yes).
}
  \item{pain_worsens_with_movement_palpation}{
Numeric (0 or 1). Pain worsens with movement or palpation. (1 = Yes).
}
  \item{vomiting}{
Numeric (0 or 1). Associated vomiting. (1 = Yes).
}
}
\value{
A list containing:
\item{Probability_ACS}{The calculated probability of ACS.}
\item{Risk_Category}{Risk stratification (Very Low, Low, Moderate, High).}
}
\references{
Body R, et al. The Manchester Acute Coronary Syndromes (MACS) decision rule for suspected cardiac chest pain: derivation and external validation. Heart. 2014;100(18):1462-1468. doi:10.1136/heartjnl-2014-305564
Body R, et al. A rapid rule-out for acute coronary syndromes using a single high-sensitivity cardiac troponin T measurement: the T-MACS decision aid.
}
\examples{

# Example 1: High Risk
# hs-cTnT 50, H-FABP 6, ECG Ischemia, Sweating
# Log-odds calculation leads to high probability
t_macs_decision_aid(50, 6, 1, 1, 0, 0, 0)

# Example 2: Very Low Risk
# hs-cTnT 3, H-FABP 1.5, No symptoms
t_macs_decision_aid(3, 1.5, 0, 0, 0, 0, 0)
}
