\name{ssign_rcc_score}
\alias{ssign_rcc_score}
\title{
SSIGN Score for Renal Cell Carcinoma (RCC)
}
\description{
Calculates the SSIGN (Stage, Size, Grade, and Necrosis) Score to predict cancer-specific survival outcomes in patients with clear cell Renal Cell Carcinoma (ccRCC) after radical or partial nephrectomy.
}
\usage{
ssign_rcc_score(pathologic_t_stage, lymph_node_status, metastasis_status,
                tumor_size_ge_5cm, fuhrman_grade, tumor_necrosis_present)
}
\arguments{
  \item{pathologic_t_stage}{
String. Pathologic T Stage (2002 TNM).
"t1a": 0 pts.
"t1b": 2 pts.
"t2": 3 pts.
"t3a", "t3b", "t3c": 4 pts.
"t4": 5 pts.
}
  \item{lymph_node_status}{
String. Regional Lymph Node status.
"n0" or "nx": 0 pts.
"n1" or "n2": 2 pts.
}
  \item{metastasis_status}{
Numeric (0 or 1). Distant metastasis (M1). (1 = Yes, +4 pts).
}
  \item{tumor_size_ge_5cm}{
Numeric (0 or 1). Tumor size >= 5 cm. (1 = Yes, +2 pts).
}
  \item{fuhrman_grade}{
Numeric (1-4). Fuhrman Nuclear Grade.
1 or 2: 0 pts.
3: 1 pt.
4: 3 pts.
}
  \item{tumor_necrosis_present}{
Numeric (0 or 1). Presence of tumor necrosis. (1 = Yes, +2 pts).
}
}
\value{
A list containing:
\item{SSIGN_Score}{The calculated total score (Range 0-18).}
\item{Est_5_Year_Survival}{Estimated 5-year cancer-specific survival percentage.}
}
\references{
Frank I, Blute ML, Cheville JC, et al. An outcome prediction model for patients with clear cell renal cell carcinoma treated with radical nephrectomy based on tumor stage, size, grade and necrosis: the SSIGN score. J Urol. 2002;168(6):2395-2400. doi:10.1016/S0022-5347(05)64153-5
}
\examples{

# Example 1: High Risk
# T3a (+4), N0 (0), M0 (0), Size 6cm (+2), Grade 4 (+3), Necrosis (+2)
# Score = 11
ssign_rcc_score("t3a", "n0", 0, 1, 4, 1)

# Example 2: Low Risk
# T1a (0), N0 (0), M0 (0), Size 3cm (0), Grade 2 (0), No Necrosis (0)
# Score = 0
ssign_rcc_score("t1a", "n0", 0, 0, 2, 0)
}
