\name{shorr_score_mrsa}
\alias{shorr_score_mrsa}
\title{
Shorr Score for MRSA Pneumonia
}
\description{
Calculates the Shorr Score to predict the probability of Methicillin-resistant Staphylococcus aureus (MRSA) etiology in patients with pneumonia. The score helps identify patients at low risk who may not require empiric anti-MRSA therapy.
}
\usage{
shorr_score_mrsa(age, nursing_home, heart_failure, cerebrovascular_disease,
                 diabetes, icu_admission_24h)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<30: 0 pts
30-39: 1 pt
40-49: 2 pts
50-59: 3 pts
60-69: 4 pts
70-79: 5 pts
>=80: 6 pts
}
  \item{nursing_home}{
Numeric (0 or 1). Residence in a nursing home or extended care facility. (1 = Yes, +4 pts).
}
  \item{heart_failure}{
Numeric (0 or 1). History of heart failure. (1 = Yes, +2 pts).
}
  \item{cerebrovascular_disease}{
Numeric (0 or 1). History of cerebrovascular disease (e.g., stroke, TIA). (1 = Yes, +2 pts).
}
  \item{diabetes}{
Numeric (0 or 1). History of diabetes mellitus. (1 = Yes, +1 pt).
}
  \item{icu_admission_24h}{
Numeric (0 or 1). Admission to the ICU within 24 hours of presentation. (1 = Yes, +2 pts).
}
}
\value{
A list containing:
\item{Shorr_Score}{The calculated total score (Range 0-17).}
\item{Risk_Category}{Classification (Low 0-1, Intermediate 2-5, High >=6).}
}
\references{
Shorr AF, Zilberberg MD, Micek ST, Kollef MH. Prediction of infection due to antibiotic-resistant bacteria by select risk factors for health care-associated pneumonia. Arch Intern Med. 2008;168(20):2205-2210. doi:10.1001/archinte.168.20.2205
}
\examples{

# Example 1: Low Risk
# Age 45 (+2), No other factors
# Score = 2
# Let's recheck 45yo -> 2 pts.
# 2 points -> Intermediate.
shorr_score_mrsa(45, 0, 0, 0, 0, 0)

# Example 2: High Risk
# Age 80 (+6), Nursing Home (+4), Diabetes (+1)
# Score = 11
shorr_score_mrsa(80, 1, 0, 0, 1, 0)
}
