\name{save_ecmo_score}
\alias{save_ecmo_score}
\title{
SAVE Score for Veno-Arterial (VA) ECMO Survival
}
\description{
Calculates the Survival After Veno-arterial ECMO (SAVE) Score to predict in-hospital survival for adult patients with refractory cardiogenic shock treated with VA-ECMO. The score stratifies patients into five risk classes based on 12 pre-ECMO clinical parameters.
}
\usage{
save_ecmo_score(age, weight_kg, diagnosis_category, chronic_renal_failure,
                acute_renal_failure, liver_failure, cns_dysfunction,
                intubation_duration_hours, peak_inspiratory_pressure,
                cardiac_arrest_pre_ecmo, diastolic_bp_pre_ecmo,
                pulse_pressure_pre_ecmo, bicarbonate_pre_ecmo)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{weight_kg}{
Numeric. Patient weight in kg.
}
  \item{diagnosis_category}{
String. Etiology of cardiogenic shock.
"chronic_heart_failure" (-5)
"myocarditis" (+3)
"refractory_vt_vf" (+2)
"post_transplant" (+3)
"congenital_heart_disease" (-3)
"other" (-1) (e.g., postpartum, toxic, idiopathic)
}
  \item{chronic_renal_failure}{
Numeric (0 or 1). Chronic renal failure history (Stage 3+ or damage > 3 months). (1 = Yes, -6 pts).
}
  \item{acute_renal_failure}{
Numeric (0 or 1). Acute renal failure pre-ECMO. (1 = Yes, -3 pts).
}
  \item{liver_failure}{
Numeric (0 or 1). Liver failure (Bili >= 33 umol/L or Transaminases > 70 U/L). (1 = Yes, -3 pts).
}
  \item{cns_dysfunction}{
Numeric (0 or 1). Central nervous system dysfunction. (1 = Yes, -3 pts).
}
  \item{intubation_duration_hours}{
Numeric. Hours intubated prior to ECMO initiation.
<= 10 hours (0 pts)
11-29 hours (-2 pts)
>= 30 hours (-4 pts)
}
  \item{peak_inspiratory_pressure}{
Numeric. Peak inspiratory pressure (PIP) in cmH2O. (<= 20 cmH2O adds +3 pts).
}
  \item{cardiac_arrest_pre_ecmo}{
Numeric (0 or 1). Cardiac arrest prior to ECMO cannulation. (1 = Yes, -2 pts).
}
  \item{diastolic_bp_pre_ecmo}{
Numeric. Diastolic blood pressure pre-ECMO (worst value in 6h). (>= 40 mmHg adds +3 pts).
}
  \item{pulse_pressure_pre_ecmo}{
Numeric. Pulse pressure pre-ECMO (worst value in 6h). (<= 20 mmHg subtracts -2 pts).
}
  \item{bicarbonate_pre_ecmo}{
Numeric. Serum bicarbonate pre-ECMO (worst value in 6h). (<= 15 mmol/L subtracts -3 pts).
}
}
\value{
A list containing:
\item{SAVE_Score}{The calculated total score (Range -35 to +17).}
\item{Risk_Class}{Risk classification (Class I to V).}
\item{Est_Hospital_Survival}{Estimated survival percentage.}
}
\references{
Schmidt M, Burrell A, Roberts L, et al. Predicting survival after ECMO for refractory cardiogenic shock: the survival after veno-arterial-ECMO (SAVE)-score. Eur Heart J. 2015;36(33):2246-2256. doi:10.1093/eurheartj/ehv162
}
\examples{

# Example 1: Good Candidate (Class I)
# 30yo (+7), 70kg (+2), Myocarditis (+3), No Failures, 5h vent (0),
#PIP 18 (+3), No Arrest (0), DBP 60 (+3), PP 30 (0), HCO3 24 (0)
# Score = 7 + 2 + 3 + 0 + 3 + 0 + 3 = 18
save_ecmo_score(30, 70, "myocarditis", 0, 0, 0, 0, 5, 18, 0, 60, 30, 24)

# Example 2: Poor Candidate (Class V)
# 70yo (0), 80kg (+2), Chronic HF (-5), Chronic Renal (-6), 48h vent (-4),
#Arrest (-2), DBP 30 (0), PP 15 (-2), HCO3 12 (-3)
# Score = 0 + 2 - 5 - 6 - 4 - 2 - 2 - 3 = -20
save_ecmo_score(70, 80, "chronic_heart_failure", 1, 0, 0, 0, 48, 30, 1, 30, 15, 12)
}
