\name{rome_iv_unspecified_functional_bowel_disorder}
\alias{rome_iv_unspecified_functional_bowel_disorder}
\title{
Rome IV Diagnostic Criteria for Unspecified Functional Bowel Disorder
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Unspecified Functional Bowel Disorder**. This is a residual category diagnosis applied when patients have chronic, recurrent abdominal symptoms but do not meet the full diagnostic criteria for Irritable Bowel Syndrome (IBS), Functional Constipation, Functional Diarrhea, or Functional Abdominal Bloating/Distension.
}
\usage{
rome_iv_unspecified_functional_bowel_disorder(abdominal_symptoms_ge_1_day_week,
                                              other_fgid_excluded,
                                              symptom_onset_ge_6_months,
                                              symptoms_active_last_3_months)
}
\arguments{
  \item{abdominal_symptoms_ge_1_day_week}{
Numeric (0 or 1). Presence of recurrent abdominal symptoms (e.g., pain, discomfort, bloating, distension) occurring on average at least **1 day per week**. (1 = Yes).
}
  \item{other_fgid_excluded}{
Numeric (0 or 1). Does the patient **NOT** meet the full diagnostic criteria for IBS, functional constipation, functional diarrhea, or functional bloating? (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least **6 months ago**? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last **3 months**? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Unspecified Functional Bowel Disorder" or "Criteria Not Met".}
}
\references{
Lacy BE, Mearin F, Chang L, et al. Bowel Disorders. Gastroenterology. 2016;150:1393-1407. doi:10.1053/j.gastro.2016.02.031
}
\examples{

# Example 1: Diagnosis Met
# Recurrent symptoms >1/wk, Does not meet full criteria for IBS/Constipation, Chronic duration met
rome_iv_unspecified_functional_bowel_disorder(1, 1, 1, 1)

# Example 2: Not Met (Meets IBS criteria)
# Recurrent symptoms >1/wk, Meets full criteria for IBS (0 for other_fgid_excluded)
rome_iv_unspecified_functional_bowel_disorder(1, 0, 1, 1)
}
